/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-18 at 10:24:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4;

/**
 * Service definition for Sheets (v4).
 *
 * <p>
 * Reads and writes Google Sheets.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/sheets/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link SheetsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Sheets extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Google Sheets API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://sheets.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Sheets(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Sheets(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Spreadsheets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Sheets sheets = new Sheets(...);}
   *   {@code Sheets.Spreadsheets.List request = sheets.spreadsheets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Spreadsheets spreadsheets() {
    return new Spreadsheets();
  }

  /**
   * The "spreadsheets" collection of methods.
   */
  public class Spreadsheets {

    /**
     * Applies one or more updates to the spreadsheet.
     *
     * Each request is validated before being applied. If any request is not valid then the entire
     * request will fail and nothing will be applied.
     *
     * Some requests have replies to give you some information about how they are applied. The replies
     * will mirror the requests.  For example, if you applied 4 updates and the 3rd one had a reply,
     * then the response will have 2 empty replies, the actual reply, and another empty reply, in that
     * order.
     *
     * Due to the collaborative nature of spreadsheets, it is not guaranteed that the spreadsheet will
     * reflect exactly your changes after this completes, however it is guaranteed that the updates in
     * the request will be applied together atomically. Your changes may be altered with respect to
     * collaborator changes. If there are no collaborators, the spreadsheet should reflect your changes.
     *
     * Create a request for the method "spreadsheets.batchUpdate".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation.
     *
     * @param spreadsheetId The spreadsheet to apply the updates to.
     * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest}
     * @return the request
     */
    public BatchUpdate batchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest content) throws java.io.IOException {
      BatchUpdate result = new BatchUpdate(spreadsheetId, content);
      initialize(result);
      return result;
    }

    public class BatchUpdate extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse> {

      private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:batchUpdate";

      /**
       * Applies one or more updates to the spreadsheet.
       *
       * Each request is validated before being applied. If any request is not valid then the entire
       * request will fail and nothing will be applied.
       *
       * Some requests have replies to give you some information about how they are applied. The replies
       * will mirror the requests.  For example, if you applied 4 updates and the 3rd one had a reply,
       * then the response will have 2 empty replies, the actual reply, and another empty reply, in that
       * order.
       *
       * Due to the collaborative nature of spreadsheets, it is not guaranteed that the spreadsheet will
       * reflect exactly your changes after this completes, however it is guaranteed that the updates in
       * the request will be applied together atomically. Your changes may be altered with respect to
       * collaborator changes. If there are no collaborators, the spreadsheet should reflect your
       * changes.
       *
       * Create a request for the method "spreadsheets.batchUpdate".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation. <p>
       * {@link
       * BatchUpdate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param spreadsheetId The spreadsheet to apply the updates to.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest}
       * @since 1.13
       */
      protected BatchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest content) {
        super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse.class);
        this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
      }

      @Override
      public BatchUpdate set$Xgafv(java.lang.String $Xgafv) {
        return (BatchUpdate) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchUpdate setAccessToken(java.lang.String accessToken) {
        return (BatchUpdate) super.setAccessToken(accessToken);
      }

      @Override
      public BatchUpdate setAlt(java.lang.String alt) {
        return (BatchUpdate) super.setAlt(alt);
      }

      @Override
      public BatchUpdate setCallback(java.lang.String callback) {
        return (BatchUpdate) super.setCallback(callback);
      }

      @Override
      public BatchUpdate setFields(java.lang.String fields) {
        return (BatchUpdate) super.setFields(fields);
      }

      @Override
      public BatchUpdate setKey(java.lang.String key) {
        return (BatchUpdate) super.setKey(key);
      }

      @Override
      public BatchUpdate setOauthToken(java.lang.String oauthToken) {
        return (BatchUpdate) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchUpdate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchUpdate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchUpdate setQuotaUser(java.lang.String quotaUser) {
        return (BatchUpdate) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchUpdate setUploadType(java.lang.String uploadType) {
        return (BatchUpdate) super.setUploadType(uploadType);
      }

      @Override
      public BatchUpdate setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchUpdate) super.setUploadProtocol(uploadProtocol);
      }

      /** The spreadsheet to apply the updates to. */
      @com.google.api.client.util.Key
      private java.lang.String spreadsheetId;

      /** The spreadsheet to apply the updates to.
       */
      public java.lang.String getSpreadsheetId() {
        return spreadsheetId;
      }

      /** The spreadsheet to apply the updates to. */
      public BatchUpdate setSpreadsheetId(java.lang.String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
        return this;
      }

      @Override
      public BatchUpdate set(String parameterName, Object value) {
        return (BatchUpdate) super.set(parameterName, value);
      }
    }
    /**
     * Creates a spreadsheet, returning the newly created spreadsheet.
     *
     * Create a request for the method "spreadsheets.create".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.sheets.v4.model.Spreadsheet}
     * @return the request
     */
    public Create create(com.google.api.services.sheets.v4.model.Spreadsheet content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends SheetsRequest<com.google.api.services.sheets.v4.model.Spreadsheet> {

      private static final String REST_PATH = "v4/spreadsheets";

      /**
       * Creates a spreadsheet, returning the newly created spreadsheet.
       *
       * Create a request for the method "spreadsheets.create".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.sheets.v4.model.Spreadsheet}
       * @since 1.13
       */
      protected Create(com.google.api.services.sheets.v4.model.Spreadsheet content) {
        super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.Spreadsheet.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
     *
     * By default, data within grids will not be returned. You can include grid data one of two ways:
     *
     * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
     *
     * * Set the includeGridData URL parameter to true.  If a field mask is set, the `includeGridData`
     * parameter is ignored
     *
     * For large spreadsheets, it is recommended to retrieve only the specific fields of the spreadsheet
     * that you want.
     *
     * To retrieve only subsets of the spreadsheet, use the ranges URL parameter. Multiple ranges can be
     * specified.  Limiting the range will return only the portions of the spreadsheet that intersect
     * the requested ranges. Ranges are specified using A1 notation.
     *
     * Create a request for the method "spreadsheets.get".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param spreadsheetId The spreadsheet to request.
     * @return the request
     */
    public Get get(java.lang.String spreadsheetId) throws java.io.IOException {
      Get result = new Get(spreadsheetId);
      initialize(result);
      return result;
    }

    public class Get extends SheetsRequest<com.google.api.services.sheets.v4.model.Spreadsheet> {

      private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}";

      /**
       * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
       *
       * By default, data within grids will not be returned. You can include grid data one of two ways:
       *
       * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
       *
       * * Set the includeGridData URL parameter to true.  If a field mask is set, the `includeGridData`
       * parameter is ignored
       *
       * For large spreadsheets, it is recommended to retrieve only the specific fields of the
       * spreadsheet that you want.
       *
       * To retrieve only subsets of the spreadsheet, use the ranges URL parameter. Multiple ranges can
       * be specified.  Limiting the range will return only the portions of the spreadsheet that
       * intersect the requested ranges. Ranges are specified using A1 notation.
       *
       * Create a request for the method "spreadsheets.get".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param spreadsheetId The spreadsheet to request.
       * @since 1.13
       */
      protected Get(java.lang.String spreadsheetId) {
        super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.Spreadsheet.class);
        this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The spreadsheet to request. */
      @com.google.api.client.util.Key
      private java.lang.String spreadsheetId;

      /** The spreadsheet to request.
       */
      public java.lang.String getSpreadsheetId() {
        return spreadsheetId;
      }

      /** The spreadsheet to request. */
      public Get setSpreadsheetId(java.lang.String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
        return this;
      }

      /** The ranges to retrieve from the spreadsheet. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> ranges;

      /** The ranges to retrieve from the spreadsheet.
       */
      public java.util.List<java.lang.String> getRanges() {
        return ranges;
      }

      /** The ranges to retrieve from the spreadsheet. */
      public Get setRanges(java.util.List<java.lang.String> ranges) {
        this.ranges = ranges;
        return this;
      }

      /**
       * True if grid data should be returned. This parameter is ignored if a field mask was set in
       * the request.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeGridData;

      /** True if grid data should be returned. This parameter is ignored if a field mask was set in the
     request.
       */
      public java.lang.Boolean getIncludeGridData() {
        return includeGridData;
      }

      /**
       * True if grid data should be returned. This parameter is ignored if a field mask was set in
       * the request.
       */
      public Get setIncludeGridData(java.lang.Boolean includeGridData) {
        this.includeGridData = includeGridData;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
     *
     * This method differs from GetSpreadsheet in that it allows selecting which subsets of spreadsheet
     * data to return by specifying a dataFilters parameter. Multiple DataFilters can be specified.
     * Specifying one or more data filters will return the portions of the spreadsheet that intersect
     * ranges matched by any of the filters.
     *
     * By default, data within grids will not be returned. You can include grid data one of two ways:
     *
     * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
     *
     * * Set the includeGridData parameter to true.  If a field mask is set, the `includeGridData`
     * parameter is ignored
     *
     * For large spreadsheets, it is recommended to retrieve only the specific fields of the spreadsheet
     * that you want.
     *
     * Create a request for the method "spreadsheets.getByDataFilter".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link GetByDataFilter#execute()} method to invoke the remote operation.
     *
     * @param spreadsheetId The spreadsheet to request.
     * @param content the {@link com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest}
     * @return the request
     */
    public GetByDataFilter getByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest content) throws java.io.IOException {
      GetByDataFilter result = new GetByDataFilter(spreadsheetId, content);
      initialize(result);
      return result;
    }

    public class GetByDataFilter extends SheetsRequest<com.google.api.services.sheets.v4.model.Spreadsheet> {

      private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:getByDataFilter";

      /**
       * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
       *
       * This method differs from GetSpreadsheet in that it allows selecting which subsets of
       * spreadsheet data to return by specifying a dataFilters parameter. Multiple DataFilters can be
       * specified.  Specifying one or more data filters will return the portions of the spreadsheet
       * that intersect ranges matched by any of the filters.
       *
       * By default, data within grids will not be returned. You can include grid data one of two ways:
       *
       * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
       *
       * * Set the includeGridData parameter to true.  If a field mask is set, the `includeGridData`
       * parameter is ignored
       *
       * For large spreadsheets, it is recommended to retrieve only the specific fields of the
       * spreadsheet that you want.
       *
       * Create a request for the method "spreadsheets.getByDataFilter".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link GetByDataFilter#execute()} method to invoke the remote operation.
       * <p> {@link GetByDataFilter#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param spreadsheetId The spreadsheet to request.
       * @param content the {@link com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest}
       * @since 1.13
       */
      protected GetByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest content) {
        super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.Spreadsheet.class);
        this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
      }

      @Override
      public GetByDataFilter set$Xgafv(java.lang.String $Xgafv) {
        return (GetByDataFilter) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetByDataFilter setAccessToken(java.lang.String accessToken) {
        return (GetByDataFilter) super.setAccessToken(accessToken);
      }

      @Override
      public GetByDataFilter setAlt(java.lang.String alt) {
        return (GetByDataFilter) super.setAlt(alt);
      }

      @Override
      public GetByDataFilter setCallback(java.lang.String callback) {
        return (GetByDataFilter) super.setCallback(callback);
      }

      @Override
      public GetByDataFilter setFields(java.lang.String fields) {
        return (GetByDataFilter) super.setFields(fields);
      }

      @Override
      public GetByDataFilter setKey(java.lang.String key) {
        return (GetByDataFilter) super.setKey(key);
      }

      @Override
      public GetByDataFilter setOauthToken(java.lang.String oauthToken) {
        return (GetByDataFilter) super.setOauthToken(oauthToken);
      }

      @Override
      public GetByDataFilter setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetByDataFilter) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetByDataFilter setQuotaUser(java.lang.String quotaUser) {
        return (GetByDataFilter) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetByDataFilter setUploadType(java.lang.String uploadType) {
        return (GetByDataFilter) super.setUploadType(uploadType);
      }

      @Override
      public GetByDataFilter setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetByDataFilter) super.setUploadProtocol(uploadProtocol);
      }

      /** The spreadsheet to request. */
      @com.google.api.client.util.Key
      private java.lang.String spreadsheetId;

      /** The spreadsheet to request.
       */
      public java.lang.String getSpreadsheetId() {
        return spreadsheetId;
      }

      /** The spreadsheet to request. */
      public GetByDataFilter setSpreadsheetId(java.lang.String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
        return this;
      }

      @Override
      public GetByDataFilter set(String parameterName, Object value) {
        return (GetByDataFilter) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the DeveloperMetadata collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Sheets sheets = new Sheets(...);}
     *   {@code Sheets.DeveloperMetadata.List request = sheets.developerMetadata().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DeveloperMetadata developerMetadata() {
      return new DeveloperMetadata();
    }

    /**
     * The "developerMetadata" collection of methods.
     */
    public class DeveloperMetadata {

      /**
       * Returns the developer metadata with the specified ID. The caller must specify the spreadsheet ID
       * and the developer metadata's unique metadataId.
       *
       * Create a request for the method "developerMetadata.get".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve metadata from.
       * @param metadataId The ID of the developer metadata to retrieve.
       * @return the request
       */
      public Get get(java.lang.String spreadsheetId, java.lang.Integer metadataId) throws java.io.IOException {
        Get result = new Get(spreadsheetId, metadataId);
        initialize(result);
        return result;
      }

      public class Get extends SheetsRequest<com.google.api.services.sheets.v4.model.DeveloperMetadata> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata/{metadataId}";

        /**
         * Returns the developer metadata with the specified ID. The caller must specify the spreadsheet
         * ID and the developer metadata's unique metadataId.
         *
         * Create a request for the method "developerMetadata.get".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve metadata from.
         * @param metadataId The ID of the developer metadata to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String spreadsheetId, java.lang.Integer metadataId) {
          super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.DeveloperMetadata.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.metadataId = com.google.api.client.util.Preconditions.checkNotNull(metadataId, "Required parameter metadataId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve metadata from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve metadata from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve metadata from. */
        public Get setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The ID of the developer metadata to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.Integer metadataId;

        /** The ID of the developer metadata to retrieve.
         */
        public java.lang.Integer getMetadataId() {
          return metadataId;
        }

        /** The ID of the developer metadata to retrieve. */
        public Get setMetadataId(java.lang.Integer metadataId) {
          this.metadataId = metadataId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Returns all developer metadata matching the specified DataFilter. If the provided DataFilter
       * represents a DeveloperMetadataLookup object, this will return all DeveloperMetadata entries
       * selected by it. If the DataFilter represents a location in a spreadsheet, this will return all
       * developer metadata associated with locations intersecting that region.
       *
       * Create a request for the method "developerMetadata.search".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Search#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve metadata from.
       * @param content the {@link com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest}
       * @return the request
       */
      public Search search(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest content) throws java.io.IOException {
        Search result = new Search(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class Search extends SheetsRequest<com.google.api.services.sheets.v4.model.SearchDeveloperMetadataResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata:search";

        /**
         * Returns all developer metadata matching the specified DataFilter. If the provided DataFilter
         * represents a DeveloperMetadataLookup object, this will return all DeveloperMetadata entries
         * selected by it. If the DataFilter represents a location in a spreadsheet, this will return all
         * developer metadata associated with locations intersecting that region.
         *
         * Create a request for the method "developerMetadata.search".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Search#execute()} method to invoke the remote operation. <p> {@link
         * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve metadata from.
         * @param content the {@link com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest}
         * @since 1.13
         */
        protected Search(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.SearchDeveloperMetadataResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public Search set$Xgafv(java.lang.String $Xgafv) {
          return (Search) super.set$Xgafv($Xgafv);
        }

        @Override
        public Search setAccessToken(java.lang.String accessToken) {
          return (Search) super.setAccessToken(accessToken);
        }

        @Override
        public Search setAlt(java.lang.String alt) {
          return (Search) super.setAlt(alt);
        }

        @Override
        public Search setCallback(java.lang.String callback) {
          return (Search) super.setCallback(callback);
        }

        @Override
        public Search setFields(java.lang.String fields) {
          return (Search) super.setFields(fields);
        }

        @Override
        public Search setKey(java.lang.String key) {
          return (Search) super.setKey(key);
        }

        @Override
        public Search setOauthToken(java.lang.String oauthToken) {
          return (Search) super.setOauthToken(oauthToken);
        }

        @Override
        public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Search) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Search setQuotaUser(java.lang.String quotaUser) {
          return (Search) super.setQuotaUser(quotaUser);
        }

        @Override
        public Search setUploadType(java.lang.String uploadType) {
          return (Search) super.setUploadType(uploadType);
        }

        @Override
        public Search setUploadProtocol(java.lang.String uploadProtocol) {
          return (Search) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve metadata from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve metadata from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve metadata from. */
        public Search setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public Search set(String parameterName, Object value) {
          return (Search) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the SheetsOperations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Sheets sheets = new Sheets(...);}
     *   {@code Sheets.SheetsOperations.List request = sheets.sheets().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public SheetsOperations sheets() {
      return new SheetsOperations();
    }

    /**
     * The "sheets" collection of methods.
     */
    public class SheetsOperations {

      /**
       * Copies a single sheet from a spreadsheet to another spreadsheet. Returns the properties of the
       * newly created sheet.
       *
       * Create a request for the method "sheets.copyTo".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link CopyTo#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet containing the sheet to copy.
       * @param sheetId The ID of the sheet to copy.
       * @param content the {@link com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest}
       * @return the request
       */
      public CopyTo copyTo(java.lang.String spreadsheetId, java.lang.Integer sheetId, com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest content) throws java.io.IOException {
        CopyTo result = new CopyTo(spreadsheetId, sheetId, content);
        initialize(result);
        return result;
      }

      public class CopyTo extends SheetsRequest<com.google.api.services.sheets.v4.model.SheetProperties> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo";

        /**
         * Copies a single sheet from a spreadsheet to another spreadsheet. Returns the properties of the
         * newly created sheet.
         *
         * Create a request for the method "sheets.copyTo".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link CopyTo#execute()} method to invoke the remote operation. <p> {@link
         * CopyTo#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet containing the sheet to copy.
         * @param sheetId The ID of the sheet to copy.
         * @param content the {@link com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest}
         * @since 1.13
         */
        protected CopyTo(java.lang.String spreadsheetId, java.lang.Integer sheetId, com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.SheetProperties.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.sheetId = com.google.api.client.util.Preconditions.checkNotNull(sheetId, "Required parameter sheetId must be specified.");
        }

        @Override
        public CopyTo set$Xgafv(java.lang.String $Xgafv) {
          return (CopyTo) super.set$Xgafv($Xgafv);
        }

        @Override
        public CopyTo setAccessToken(java.lang.String accessToken) {
          return (CopyTo) super.setAccessToken(accessToken);
        }

        @Override
        public CopyTo setAlt(java.lang.String alt) {
          return (CopyTo) super.setAlt(alt);
        }

        @Override
        public CopyTo setCallback(java.lang.String callback) {
          return (CopyTo) super.setCallback(callback);
        }

        @Override
        public CopyTo setFields(java.lang.String fields) {
          return (CopyTo) super.setFields(fields);
        }

        @Override
        public CopyTo setKey(java.lang.String key) {
          return (CopyTo) super.setKey(key);
        }

        @Override
        public CopyTo setOauthToken(java.lang.String oauthToken) {
          return (CopyTo) super.setOauthToken(oauthToken);
        }

        @Override
        public CopyTo setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (CopyTo) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public CopyTo setQuotaUser(java.lang.String quotaUser) {
          return (CopyTo) super.setQuotaUser(quotaUser);
        }

        @Override
        public CopyTo setUploadType(java.lang.String uploadType) {
          return (CopyTo) super.setUploadType(uploadType);
        }

        @Override
        public CopyTo setUploadProtocol(java.lang.String uploadProtocol) {
          return (CopyTo) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet containing the sheet to copy. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet containing the sheet to copy.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet containing the sheet to copy. */
        public CopyTo setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The ID of the sheet to copy. */
        @com.google.api.client.util.Key
        private java.lang.Integer sheetId;

        /** The ID of the sheet to copy.
         */
        public java.lang.Integer getSheetId() {
          return sheetId;
        }

        /** The ID of the sheet to copy. */
        public CopyTo setSheetId(java.lang.Integer sheetId) {
          this.sheetId = sheetId;
          return this;
        }

        @Override
        public CopyTo set(String parameterName, Object value) {
          return (CopyTo) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Values collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Sheets sheets = new Sheets(...);}
     *   {@code Sheets.Values.List request = sheets.values().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Values values() {
      return new Values();
    }

    /**
     * The "values" collection of methods.
     */
    public class Values {

      /**
       * Appends values to a spreadsheet. The input range is used to search for existing data and find a
       * "table" within that range. Values will be appended to the next row of the table, starting with
       * the first column of the table. See the [guide](/sheets/api/guides/values#appending_values) and
       * [sample code](/sheets/api/samples/writing#append_values) for specific details of how tables are
       * detected and data is appended.
       *
       * The caller must specify the spreadsheet ID, range, and a valueInputOption.  The
       * `valueInputOption` only controls how the input data will be added to the sheet (column-wise or
       * row-wise), it does not influence what cell the data starts being written to.
       *
       * Create a request for the method "values.append".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Append#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param range The A1 notation of a range to search for a logical table of data.
      Values will be appended after the
       *        last row of the table.
       * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
       * @return the request
       */
      public Append append(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) throws java.io.IOException {
        Append result = new Append(spreadsheetId, range, content);
        initialize(result);
        return result;
      }

      public class Append extends SheetsRequest<com.google.api.services.sheets.v4.model.AppendValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:append";

        /**
         * Appends values to a spreadsheet. The input range is used to search for existing data and find a
         * "table" within that range. Values will be appended to the next row of the table, starting with
         * the first column of the table. See the [guide](/sheets/api/guides/values#appending_values) and
         * [sample code](/sheets/api/samples/writing#append_values) for specific details of how tables are
         * detected and data is appended.
         *
         * The caller must specify the spreadsheet ID, range, and a valueInputOption.  The
         * `valueInputOption` only controls how the input data will be added to the sheet (column-wise or
         * row-wise), it does not influence what cell the data starts being written to.
         *
         * Create a request for the method "values.append".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Append#execute()} method to invoke the remote operation. <p> {@link
         * Append#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param range The A1 notation of a range to search for a logical table of data.
      Values will be appended after the
       *        last row of the table.
         * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
         * @since 1.13
         */
        protected Append(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.AppendValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public Append set$Xgafv(java.lang.String $Xgafv) {
          return (Append) super.set$Xgafv($Xgafv);
        }

        @Override
        public Append setAccessToken(java.lang.String accessToken) {
          return (Append) super.setAccessToken(accessToken);
        }

        @Override
        public Append setAlt(java.lang.String alt) {
          return (Append) super.setAlt(alt);
        }

        @Override
        public Append setCallback(java.lang.String callback) {
          return (Append) super.setCallback(callback);
        }

        @Override
        public Append setFields(java.lang.String fields) {
          return (Append) super.setFields(fields);
        }

        @Override
        public Append setKey(java.lang.String key) {
          return (Append) super.setKey(key);
        }

        @Override
        public Append setOauthToken(java.lang.String oauthToken) {
          return (Append) super.setOauthToken(oauthToken);
        }

        @Override
        public Append setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Append) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Append setQuotaUser(java.lang.String quotaUser) {
          return (Append) super.setQuotaUser(quotaUser);
        }

        @Override
        public Append setUploadType(java.lang.String uploadType) {
          return (Append) super.setUploadType(uploadType);
        }

        @Override
        public Append setUploadProtocol(java.lang.String uploadProtocol) {
          return (Append) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public Append setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /**
         * The A1 notation of a range to search for a logical table of data. Values will be appended
         * after the last row of the table.
         */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of a range to search for a logical table of data. Values will be appended after the
       last row of the table.
         */
        public java.lang.String getRange() {
          return range;
        }

        /**
         * The A1 notation of a range to search for a logical table of data. Values will be appended
         * after the last row of the table.
         */
        public Append setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /**
         * Determines how values in the response should be rendered. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String responseValueRenderOption;

        /** Determines how values in the response should be rendered. The default render option is
       ValueRenderOption.FORMATTED_VALUE.
         */
        public java.lang.String getResponseValueRenderOption() {
          return responseValueRenderOption;
        }

        /**
         * Determines how values in the response should be rendered. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        public Append setResponseValueRenderOption(java.lang.String responseValueRenderOption) {
          this.responseValueRenderOption = responseValueRenderOption;
          return this;
        }

        /** How the input data should be inserted. */
        @com.google.api.client.util.Key
        private java.lang.String insertDataOption;

        /** How the input data should be inserted.
         */
        public java.lang.String getInsertDataOption() {
          return insertDataOption;
        }

        /** How the input data should be inserted. */
        public Append setInsertDataOption(java.lang.String insertDataOption) {
          this.insertDataOption = insertDataOption;
          return this;
        }

        /** How the input data should be interpreted. */
        @com.google.api.client.util.Key
        private java.lang.String valueInputOption;

        /** How the input data should be interpreted.
         */
        public java.lang.String getValueInputOption() {
          return valueInputOption;
        }

        /** How the input data should be interpreted. */
        public Append setValueInputOption(java.lang.String valueInputOption) {
          this.valueInputOption = valueInputOption;
          return this;
        }

        /**
         * Determines how dates, times, and durations in the response should be rendered. This is
         * ignored if response_value_render_option is FORMATTED_VALUE. The default dateTime render
         * option is [DateTimeRenderOption.SERIAL_NUMBER].
         */
        @com.google.api.client.util.Key
        private java.lang.String responseDateTimeRenderOption;

        /** Determines how dates, times, and durations in the response should be rendered. This is ignored if
       response_value_render_option is FORMATTED_VALUE. The default dateTime render option is
       [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public java.lang.String getResponseDateTimeRenderOption() {
          return responseDateTimeRenderOption;
        }

        /**
         * Determines how dates, times, and durations in the response should be rendered. This is
         * ignored if response_value_render_option is FORMATTED_VALUE. The default dateTime render
         * option is [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public Append setResponseDateTimeRenderOption(java.lang.String responseDateTimeRenderOption) {
          this.responseDateTimeRenderOption = responseDateTimeRenderOption;
          return this;
        }

        /**
         * Determines if the update response should include the values of the cells that were
         * appended. By default, responses do not include the updated values.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeValuesInResponse;

        /** Determines if the update response should include the values of the cells that were appended. By
       default, responses do not include the updated values.
         */
        public java.lang.Boolean getIncludeValuesInResponse() {
          return includeValuesInResponse;
        }

        /**
         * Determines if the update response should include the values of the cells that were
         * appended. By default, responses do not include the updated values.
         */
        public Append setIncludeValuesInResponse(java.lang.Boolean includeValuesInResponse) {
          this.includeValuesInResponse = includeValuesInResponse;
          return this;
        }

        @Override
        public Append set(String parameterName, Object value) {
          return (Append) super.set(parameterName, value);
        }
      }
      /**
       * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
       * ID and one or more ranges. Only values are cleared -- all other properties of the cell (such as
       * formatting, data validation, etc..) are kept.
       *
       * Create a request for the method "values.batchClear".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchClear#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchClearValuesRequest}
       * @return the request
       */
      public BatchClear batchClear(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchClearValuesRequest content) throws java.io.IOException {
        BatchClear result = new BatchClear(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchClear extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchClearValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClear";

        /**
         * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
         * ID and one or more ranges. Only values are cleared -- all other properties of the cell (such as
         * formatting, data validation, etc..) are kept.
         *
         * Create a request for the method "values.batchClear".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchClear#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchClear#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchClearValuesRequest}
         * @since 1.13
         */
        protected BatchClear(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchClearValuesRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchClearValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchClear set$Xgafv(java.lang.String $Xgafv) {
          return (BatchClear) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchClear setAccessToken(java.lang.String accessToken) {
          return (BatchClear) super.setAccessToken(accessToken);
        }

        @Override
        public BatchClear setAlt(java.lang.String alt) {
          return (BatchClear) super.setAlt(alt);
        }

        @Override
        public BatchClear setCallback(java.lang.String callback) {
          return (BatchClear) super.setCallback(callback);
        }

        @Override
        public BatchClear setFields(java.lang.String fields) {
          return (BatchClear) super.setFields(fields);
        }

        @Override
        public BatchClear setKey(java.lang.String key) {
          return (BatchClear) super.setKey(key);
        }

        @Override
        public BatchClear setOauthToken(java.lang.String oauthToken) {
          return (BatchClear) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchClear setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchClear) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchClear setQuotaUser(java.lang.String quotaUser) {
          return (BatchClear) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchClear setUploadType(java.lang.String uploadType) {
          return (BatchClear) super.setUploadType(uploadType);
        }

        @Override
        public BatchClear setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchClear) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public BatchClear setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchClear set(String parameterName, Object value) {
          return (BatchClear) super.set(parameterName, value);
        }
      }
      /**
       * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
       * ID and one or more DataFilters. Ranges matching any of the specified data filters will be
       * cleared.  Only values are cleared -- all other properties of the cell (such as formatting, data
       * validation, etc..) are kept.
       *
       * Create a request for the method "values.batchClearByDataFilter".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchClearByDataFilter#execute()} method to invoke the remote
       * operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest}
       * @return the request
       */
      public BatchClearByDataFilter batchClearByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest content) throws java.io.IOException {
        BatchClearByDataFilter result = new BatchClearByDataFilter(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchClearByDataFilter extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClearByDataFilter";

        /**
         * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
         * ID and one or more DataFilters. Ranges matching any of the specified data filters will be
         * cleared.  Only values are cleared -- all other properties of the cell (such as formatting, data
         * validation, etc..) are kept.
         *
         * Create a request for the method "values.batchClearByDataFilter".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchClearByDataFilter#execute()} method to invoke the remote
         * operation. <p> {@link BatchClearByDataFilter#initialize(com.google.api.client.googleapis.servic
         * es.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest}
         * @since 1.13
         */
        protected BatchClearByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchClearByDataFilter set$Xgafv(java.lang.String $Xgafv) {
          return (BatchClearByDataFilter) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchClearByDataFilter setAccessToken(java.lang.String accessToken) {
          return (BatchClearByDataFilter) super.setAccessToken(accessToken);
        }

        @Override
        public BatchClearByDataFilter setAlt(java.lang.String alt) {
          return (BatchClearByDataFilter) super.setAlt(alt);
        }

        @Override
        public BatchClearByDataFilter setCallback(java.lang.String callback) {
          return (BatchClearByDataFilter) super.setCallback(callback);
        }

        @Override
        public BatchClearByDataFilter setFields(java.lang.String fields) {
          return (BatchClearByDataFilter) super.setFields(fields);
        }

        @Override
        public BatchClearByDataFilter setKey(java.lang.String key) {
          return (BatchClearByDataFilter) super.setKey(key);
        }

        @Override
        public BatchClearByDataFilter setOauthToken(java.lang.String oauthToken) {
          return (BatchClearByDataFilter) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchClearByDataFilter setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchClearByDataFilter) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchClearByDataFilter setQuotaUser(java.lang.String quotaUser) {
          return (BatchClearByDataFilter) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchClearByDataFilter setUploadType(java.lang.String uploadType) {
          return (BatchClearByDataFilter) super.setUploadType(uploadType);
        }

        @Override
        public BatchClearByDataFilter setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchClearByDataFilter) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public BatchClearByDataFilter setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchClearByDataFilter set(String parameterName, Object value) {
          return (BatchClearByDataFilter) super.set(parameterName, value);
        }
      }
      /**
       * Returns one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
       * ID and one or more ranges.
       *
       * Create a request for the method "values.batchGet".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
       * @return the request
       */
      public BatchGet batchGet(java.lang.String spreadsheetId) throws java.io.IOException {
        BatchGet result = new BatchGet(spreadsheetId);
        initialize(result);
        return result;
      }

      public class BatchGet extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchGetValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGet";

        /**
         * Returns one or more ranges of values from a spreadsheet. The caller must specify the
         * spreadsheet ID and one or more ranges.
         *
         * Create a request for the method "values.batchGet".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
         * @since 1.13
         */
        protected BatchGet(java.lang.String spreadsheetId) {
          super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.BatchGetValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public BatchGet set$Xgafv(java.lang.String $Xgafv) {
          return (BatchGet) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchGet setAccessToken(java.lang.String accessToken) {
          return (BatchGet) super.setAccessToken(accessToken);
        }

        @Override
        public BatchGet setAlt(java.lang.String alt) {
          return (BatchGet) super.setAlt(alt);
        }

        @Override
        public BatchGet setCallback(java.lang.String callback) {
          return (BatchGet) super.setCallback(callback);
        }

        @Override
        public BatchGet setFields(java.lang.String fields) {
          return (BatchGet) super.setFields(fields);
        }

        @Override
        public BatchGet setKey(java.lang.String key) {
          return (BatchGet) super.setKey(key);
        }

        @Override
        public BatchGet setOauthToken(java.lang.String oauthToken) {
          return (BatchGet) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchGet) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchGet setQuotaUser(java.lang.String quotaUser) {
          return (BatchGet) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchGet setUploadType(java.lang.String uploadType) {
          return (BatchGet) super.setUploadType(uploadType);
        }

        @Override
        public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchGet) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve data from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve data from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve data from. */
        public BatchGet setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /**
         * How values should be represented in the output. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String valueRenderOption;

        /** How values should be represented in the output. The default render option is
       ValueRenderOption.FORMATTED_VALUE.
         */
        public java.lang.String getValueRenderOption() {
          return valueRenderOption;
        }

        /**
         * How values should be represented in the output. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        public BatchGet setValueRenderOption(java.lang.String valueRenderOption) {
          this.valueRenderOption = valueRenderOption;
          return this;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE. The default dateTime render option is
         * [DateTimeRenderOption.SERIAL_NUMBER].
         */
        @com.google.api.client.util.Key
        private java.lang.String dateTimeRenderOption;

        /** How dates, times, and durations should be represented in the output. This is ignored if
       value_render_option is FORMATTED_VALUE. The default dateTime render option is
       [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public java.lang.String getDateTimeRenderOption() {
          return dateTimeRenderOption;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE. The default dateTime render option is
         * [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public BatchGet setDateTimeRenderOption(java.lang.String dateTimeRenderOption) {
          this.dateTimeRenderOption = dateTimeRenderOption;
          return this;
        }

        /** The A1 notation of the values to retrieve. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> ranges;

        /** The A1 notation of the values to retrieve.
         */
        public java.util.List<java.lang.String> getRanges() {
          return ranges;
        }

        /** The A1 notation of the values to retrieve. */
        public BatchGet setRanges(java.util.List<java.lang.String> ranges) {
          this.ranges = ranges;
          return this;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        @com.google.api.client.util.Key
        private java.lang.String majorDimension;

        /** The major dimension that results should use.

       For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
       `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
       `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public java.lang.String getMajorDimension() {
          return majorDimension;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public BatchGet setMajorDimension(java.lang.String majorDimension) {
          this.majorDimension = majorDimension;
          return this;
        }

        @Override
        public BatchGet set(String parameterName, Object value) {
          return (BatchGet) super.set(parameterName, value);
        }
      }
      /**
       * Returns one or more ranges of values that match the specified data filters. The caller must
       * specify the spreadsheet ID and one or more DataFilters.  Ranges that match any of the data
       * filters in the request will be returned.
       *
       * Create a request for the method "values.batchGetByDataFilter".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchGetByDataFilter#execute()} method to invoke the remote
       * operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest}
       * @return the request
       */
      public BatchGetByDataFilter batchGetByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest content) throws java.io.IOException {
        BatchGetByDataFilter result = new BatchGetByDataFilter(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchGetByDataFilter extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGetByDataFilter";

        /**
         * Returns one or more ranges of values that match the specified data filters. The caller must
         * specify the spreadsheet ID and one or more DataFilters.  Ranges that match any of the data
         * filters in the request will be returned.
         *
         * Create a request for the method "values.batchGetByDataFilter".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchGetByDataFilter#execute()} method to invoke the remote
         * operation. <p> {@link BatchGetByDataFilter#initialize(com.google.api.client.googleapis.services
         * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest}
         * @since 1.13
         */
        protected BatchGetByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchGetByDataFilter set$Xgafv(java.lang.String $Xgafv) {
          return (BatchGetByDataFilter) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchGetByDataFilter setAccessToken(java.lang.String accessToken) {
          return (BatchGetByDataFilter) super.setAccessToken(accessToken);
        }

        @Override
        public BatchGetByDataFilter setAlt(java.lang.String alt) {
          return (BatchGetByDataFilter) super.setAlt(alt);
        }

        @Override
        public BatchGetByDataFilter setCallback(java.lang.String callback) {
          return (BatchGetByDataFilter) super.setCallback(callback);
        }

        @Override
        public BatchGetByDataFilter setFields(java.lang.String fields) {
          return (BatchGetByDataFilter) super.setFields(fields);
        }

        @Override
        public BatchGetByDataFilter setKey(java.lang.String key) {
          return (BatchGetByDataFilter) super.setKey(key);
        }

        @Override
        public BatchGetByDataFilter setOauthToken(java.lang.String oauthToken) {
          return (BatchGetByDataFilter) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchGetByDataFilter setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchGetByDataFilter) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchGetByDataFilter setQuotaUser(java.lang.String quotaUser) {
          return (BatchGetByDataFilter) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchGetByDataFilter setUploadType(java.lang.String uploadType) {
          return (BatchGetByDataFilter) super.setUploadType(uploadType);
        }

        @Override
        public BatchGetByDataFilter setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchGetByDataFilter) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve data from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve data from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve data from. */
        public BatchGetByDataFilter setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchGetByDataFilter set(String parameterName, Object value) {
          return (BatchGetByDataFilter) super.set(parameterName, value);
        }
      }
      /**
       * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID, a
       * valueInputOption, and one or more ValueRanges.
       *
       * Create a request for the method "values.batchUpdate".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest}
       * @return the request
       */
      public BatchUpdate batchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest content) throws java.io.IOException {
        BatchUpdate result = new BatchUpdate(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchUpdate extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdate";

        /**
         * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID,
         * a valueInputOption, and one or more ValueRanges.
         *
         * Create a request for the method "values.batchUpdate".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchUpdate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest}
         * @since 1.13
         */
        protected BatchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchUpdate set$Xgafv(java.lang.String $Xgafv) {
          return (BatchUpdate) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchUpdate setAccessToken(java.lang.String accessToken) {
          return (BatchUpdate) super.setAccessToken(accessToken);
        }

        @Override
        public BatchUpdate setAlt(java.lang.String alt) {
          return (BatchUpdate) super.setAlt(alt);
        }

        @Override
        public BatchUpdate setCallback(java.lang.String callback) {
          return (BatchUpdate) super.setCallback(callback);
        }

        @Override
        public BatchUpdate setFields(java.lang.String fields) {
          return (BatchUpdate) super.setFields(fields);
        }

        @Override
        public BatchUpdate setKey(java.lang.String key) {
          return (BatchUpdate) super.setKey(key);
        }

        @Override
        public BatchUpdate setOauthToken(java.lang.String oauthToken) {
          return (BatchUpdate) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchUpdate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchUpdate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchUpdate setQuotaUser(java.lang.String quotaUser) {
          return (BatchUpdate) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchUpdate setUploadType(java.lang.String uploadType) {
          return (BatchUpdate) super.setUploadType(uploadType);
        }

        @Override
        public BatchUpdate setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchUpdate) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public BatchUpdate setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchUpdate set(String parameterName, Object value) {
          return (BatchUpdate) super.set(parameterName, value);
        }
      }
      /**
       * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID, a
       * valueInputOption, and one or more DataFilterValueRanges.
       *
       * Create a request for the method "values.batchUpdateByDataFilter".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchUpdateByDataFilter#execute()} method to invoke the remote
       * operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest}
       * @return the request
       */
      public BatchUpdateByDataFilter batchUpdateByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest content) throws java.io.IOException {
        BatchUpdateByDataFilter result = new BatchUpdateByDataFilter(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchUpdateByDataFilter extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdateByDataFilter";

        /**
         * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID,
         * a valueInputOption, and one or more DataFilterValueRanges.
         *
         * Create a request for the method "values.batchUpdateByDataFilter".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchUpdateByDataFilter#execute()} method to invoke the remote
         * operation. <p> {@link BatchUpdateByDataFilter#initialize(com.google.api.client.googleapis.servi
         * ces.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest}
         * @since 1.13
         */
        protected BatchUpdateByDataFilter(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchUpdateByDataFilter set$Xgafv(java.lang.String $Xgafv) {
          return (BatchUpdateByDataFilter) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchUpdateByDataFilter setAccessToken(java.lang.String accessToken) {
          return (BatchUpdateByDataFilter) super.setAccessToken(accessToken);
        }

        @Override
        public BatchUpdateByDataFilter setAlt(java.lang.String alt) {
          return (BatchUpdateByDataFilter) super.setAlt(alt);
        }

        @Override
        public BatchUpdateByDataFilter setCallback(java.lang.String callback) {
          return (BatchUpdateByDataFilter) super.setCallback(callback);
        }

        @Override
        public BatchUpdateByDataFilter setFields(java.lang.String fields) {
          return (BatchUpdateByDataFilter) super.setFields(fields);
        }

        @Override
        public BatchUpdateByDataFilter setKey(java.lang.String key) {
          return (BatchUpdateByDataFilter) super.setKey(key);
        }

        @Override
        public BatchUpdateByDataFilter setOauthToken(java.lang.String oauthToken) {
          return (BatchUpdateByDataFilter) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchUpdateByDataFilter setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchUpdateByDataFilter) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchUpdateByDataFilter setQuotaUser(java.lang.String quotaUser) {
          return (BatchUpdateByDataFilter) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchUpdateByDataFilter setUploadType(java.lang.String uploadType) {
          return (BatchUpdateByDataFilter) super.setUploadType(uploadType);
        }

        @Override
        public BatchUpdateByDataFilter setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchUpdateByDataFilter) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public BatchUpdateByDataFilter setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchUpdateByDataFilter set(String parameterName, Object value) {
          return (BatchUpdateByDataFilter) super.set(parameterName, value);
        }
      }
      /**
       * Clears values from a spreadsheet. The caller must specify the spreadsheet ID and range. Only
       * values are cleared -- all other properties of the cell (such as formatting, data validation,
       * etc..) are kept.
       *
       * Create a request for the method "values.clear".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Clear#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param range The A1 notation of the values to clear.
       * @param content the {@link com.google.api.services.sheets.v4.model.ClearValuesRequest}
       * @return the request
       */
      public Clear clear(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ClearValuesRequest content) throws java.io.IOException {
        Clear result = new Clear(spreadsheetId, range, content);
        initialize(result);
        return result;
      }

      public class Clear extends SheetsRequest<com.google.api.services.sheets.v4.model.ClearValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:clear";

        /**
         * Clears values from a spreadsheet. The caller must specify the spreadsheet ID and range. Only
         * values are cleared -- all other properties of the cell (such as formatting, data validation,
         * etc..) are kept.
         *
         * Create a request for the method "values.clear".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Clear#execute()} method to invoke the remote operation. <p> {@link
         * Clear#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param range The A1 notation of the values to clear.
         * @param content the {@link com.google.api.services.sheets.v4.model.ClearValuesRequest}
         * @since 1.13
         */
        protected Clear(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ClearValuesRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.ClearValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public Clear set$Xgafv(java.lang.String $Xgafv) {
          return (Clear) super.set$Xgafv($Xgafv);
        }

        @Override
        public Clear setAccessToken(java.lang.String accessToken) {
          return (Clear) super.setAccessToken(accessToken);
        }

        @Override
        public Clear setAlt(java.lang.String alt) {
          return (Clear) super.setAlt(alt);
        }

        @Override
        public Clear setCallback(java.lang.String callback) {
          return (Clear) super.setCallback(callback);
        }

        @Override
        public Clear setFields(java.lang.String fields) {
          return (Clear) super.setFields(fields);
        }

        @Override
        public Clear setKey(java.lang.String key) {
          return (Clear) super.setKey(key);
        }

        @Override
        public Clear setOauthToken(java.lang.String oauthToken) {
          return (Clear) super.setOauthToken(oauthToken);
        }

        @Override
        public Clear setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Clear) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Clear setQuotaUser(java.lang.String quotaUser) {
          return (Clear) super.setQuotaUser(quotaUser);
        }

        @Override
        public Clear setUploadType(java.lang.String uploadType) {
          return (Clear) super.setUploadType(uploadType);
        }

        @Override
        public Clear setUploadProtocol(java.lang.String uploadProtocol) {
          return (Clear) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public Clear setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to clear. */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of the values to clear.
         */
        public java.lang.String getRange() {
          return range;
        }

        /** The A1 notation of the values to clear. */
        public Clear setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        @Override
        public Clear set(String parameterName, Object value) {
          return (Clear) super.set(parameterName, value);
        }
      }
      /**
       * Returns a range of values from a spreadsheet. The caller must specify the spreadsheet ID and a
       * range.
       *
       * Create a request for the method "values.get".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
       * @param range The A1 notation of the values to retrieve.
       * @return the request
       */
      public Get get(java.lang.String spreadsheetId, java.lang.String range) throws java.io.IOException {
        Get result = new Get(spreadsheetId, range);
        initialize(result);
        return result;
      }

      public class Get extends SheetsRequest<com.google.api.services.sheets.v4.model.ValueRange> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";

        /**
         * Returns a range of values from a spreadsheet. The caller must specify the spreadsheet ID and a
         * range.
         *
         * Create a request for the method "values.get".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
         * @param range The A1 notation of the values to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String spreadsheetId, java.lang.String range) {
          super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.ValueRange.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve data from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve data from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve data from. */
        public Get setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of the values to retrieve.
         */
        public java.lang.String getRange() {
          return range;
        }

        /** The A1 notation of the values to retrieve. */
        public Get setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /**
         * How values should be represented in the output. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String valueRenderOption;

        /** How values should be represented in the output. The default render option is
       ValueRenderOption.FORMATTED_VALUE.
         */
        public java.lang.String getValueRenderOption() {
          return valueRenderOption;
        }

        /**
         * How values should be represented in the output. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        public Get setValueRenderOption(java.lang.String valueRenderOption) {
          this.valueRenderOption = valueRenderOption;
          return this;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE. The default dateTime render option is
         * [DateTimeRenderOption.SERIAL_NUMBER].
         */
        @com.google.api.client.util.Key
        private java.lang.String dateTimeRenderOption;

        /** How dates, times, and durations should be represented in the output. This is ignored if
       value_render_option is FORMATTED_VALUE. The default dateTime render option is
       [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public java.lang.String getDateTimeRenderOption() {
          return dateTimeRenderOption;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE. The default dateTime render option is
         * [DateTimeRenderOption.SERIAL_NUMBER].
         */
        public Get setDateTimeRenderOption(java.lang.String dateTimeRenderOption) {
          this.dateTimeRenderOption = dateTimeRenderOption;
          return this;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        @com.google.api.client.util.Key
        private java.lang.String majorDimension;

        /** The major dimension that results should use.

       For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
       `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
       `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public java.lang.String getMajorDimension() {
          return majorDimension;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public Get setMajorDimension(java.lang.String majorDimension) {
          this.majorDimension = majorDimension;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Sets values in a range of a spreadsheet. The caller must specify the spreadsheet ID, range, and a
       * valueInputOption.
       *
       * Create a request for the method "values.update".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param range The A1 notation of the values to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
       * @return the request
       */
      public Update update(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) throws java.io.IOException {
        Update result = new Update(spreadsheetId, range, content);
        initialize(result);
        return result;
      }

      public class Update extends SheetsRequest<com.google.api.services.sheets.v4.model.UpdateValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";

        /**
         * Sets values in a range of a spreadsheet. The caller must specify the spreadsheet ID, range, and
         * a valueInputOption.
         *
         * Create a request for the method "values.update".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param range The A1 notation of the values to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
         * @since 1.13
         */
        protected Update(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) {
          super(Sheets.this, "PUT", REST_PATH, content, com.google.api.services.sheets.v4.model.UpdateValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public Update setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to update. */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of the values to update.
         */
        public java.lang.String getRange() {
          return range;
        }

        /** The A1 notation of the values to update. */
        public Update setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /**
         * Determines how values in the response should be rendered. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String responseValueRenderOption;

        /** Determines how values in the response should be rendered. The default render option is
       ValueRenderOption.FORMATTED_VALUE.
         */
        public java.lang.String getResponseValueRenderOption() {
          return responseValueRenderOption;
        }

        /**
         * Determines how values in the response should be rendered. The default render option is
         * ValueRenderOption.FORMATTED_VALUE.
         */
        public Update setResponseValueRenderOption(java.lang.String responseValueRenderOption) {
          this.responseValueRenderOption = responseValueRenderOption;
          return this;
        }

        /** How the input data should be interpreted. */
        @com.google.api.client.util.Key
        private java.lang.String valueInputOption;

        /** How the input data should be interpreted.
         */
        public java.lang.String getValueInputOption() {
          return valueInputOption;
        }

        /** How the input data should be interpreted. */
        public Update setValueInputOption(java.lang.String valueInputOption) {
          this.valueInputOption = valueInputOption;
          return this;
        }

        /**
         * Determines how dates, times, and durations in the response should be rendered. This is
         * ignored if response_value_render_option is FORMATTED_VALUE. The default dateTime render
         * option is DateTimeRenderOption.SERIAL_NUMBER.
         */
        @com.google.api.client.util.Key
        private java.lang.String responseDateTimeRenderOption;

        /** Determines how dates, times, and durations in the response should be rendered. This is ignored if
       response_value_render_option is FORMATTED_VALUE. The default dateTime render option is
       DateTimeRenderOption.SERIAL_NUMBER.
         */
        public java.lang.String getResponseDateTimeRenderOption() {
          return responseDateTimeRenderOption;
        }

        /**
         * Determines how dates, times, and durations in the response should be rendered. This is
         * ignored if response_value_render_option is FORMATTED_VALUE. The default dateTime render
         * option is DateTimeRenderOption.SERIAL_NUMBER.
         */
        public Update setResponseDateTimeRenderOption(java.lang.String responseDateTimeRenderOption) {
          this.responseDateTimeRenderOption = responseDateTimeRenderOption;
          return this;
        }

        /**
         * Determines if the update response should include the values of the cells that were
         * updated. By default, responses do not include the updated values. If the range to write
         * was larger than than the range actually written, the response will include all values in
         * the requested range (excluding trailing empty rows and columns).
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeValuesInResponse;

        /** Determines if the update response should include the values of the cells that were updated. By
       default, responses do not include the updated values. If the range to write was larger than than
       the range actually written, the response will include all values in the requested range (excluding
       trailing empty rows and columns).
         */
        public java.lang.Boolean getIncludeValuesInResponse() {
          return includeValuesInResponse;
        }

        /**
         * Determines if the update response should include the values of the cells that were
         * updated. By default, responses do not include the updated values. If the range to write
         * was larger than than the range actually written, the response will include all values in
         * the requested range (excluding trailing empty rows and columns).
         */
        public Update setIncludeValuesInResponse(java.lang.Boolean includeValuesInResponse) {
          this.includeValuesInResponse = includeValuesInResponse;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Sheets}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Sheets}. */
    @Override
    public Sheets build() {
      return new Sheets(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link SheetsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setSheetsRequestInitializer(
        SheetsRequestInitializer sheetsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(sheetsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
