/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-30 at 02:50:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A group over an interval of rows or columns on a sheet, which can contain or be contained within
 * other groups. A group can be collapsed or expanded as a unit on the sheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionGroup extends com.google.api.client.json.GenericJson {

  /**
   * This field is true if this group is collapsed. A collapsed group remains collapsed if an
   * overlapping group at a shallower depth is expanded.
   *
   * A true value does not imply that all dimensions within the group are hidden, since a
   * dimension's visibility can change independently from this group property. However, when this
   * property is updated, all dimensions within it are set to hidden if this field is true, or set
   * to visible if this field is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean collapsed;

  /**
   * The depth of the group, representing how many groups have a range that wholly contains the
   * range of this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer depth;

  /**
   * The range over which this group exists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange range;

  /**
   * This field is true if this group is collapsed. A collapsed group remains collapsed if an
   * overlapping group at a shallower depth is expanded.
   *
   * A true value does not imply that all dimensions within the group are hidden, since a
   * dimension's visibility can change independently from this group property. However, when this
   * property is updated, all dimensions within it are set to hidden if this field is true, or set
   * to visible if this field is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCollapsed() {
    return collapsed;
  }

  /**
   * This field is true if this group is collapsed. A collapsed group remains collapsed if an
   * overlapping group at a shallower depth is expanded.
   *
   * A true value does not imply that all dimensions within the group are hidden, since a
   * dimension's visibility can change independently from this group property. However, when this
   * property is updated, all dimensions within it are set to hidden if this field is true, or set
   * to visible if this field is false.
   * @param collapsed collapsed or {@code null} for none
   */
  public DimensionGroup setCollapsed(java.lang.Boolean collapsed) {
    this.collapsed = collapsed;
    return this;
  }

  /**
   * The depth of the group, representing how many groups have a range that wholly contains the
   * range of this group.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDepth() {
    return depth;
  }

  /**
   * The depth of the group, representing how many groups have a range that wholly contains the
   * range of this group.
   * @param depth depth or {@code null} for none
   */
  public DimensionGroup setDepth(java.lang.Integer depth) {
    this.depth = depth;
    return this;
  }

  /**
   * The range over which this group exists.
   * @return value or {@code null} for none
   */
  public DimensionRange getRange() {
    return range;
  }

  /**
   * The range over which this group exists.
   * @param range range or {@code null} for none
   */
  public DimensionGroup setRange(DimensionRange range) {
    this.range = range;
    return this;
  }

  @Override
  public DimensionGroup set(String fieldName, Object value) {
    return (DimensionGroup) super.set(fieldName, value);
  }

  @Override
  public DimensionGroup clone() {
    return (DimensionGroup) super.clone();
  }

}
