/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-01 at 23:56:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The request for retrieving a Spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetSpreadsheetByDataFilterRequest extends com.google.api.client.json.GenericJson {

  /**
   * The DataFilters used to select which ranges to retrieve from the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataFilter> dataFilters;

  /**
   * True if grid data should be returned. This parameter is ignored if a field mask was set in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeGridData;

  /**
   * The DataFilters used to select which ranges to retrieve from the spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<DataFilter> getDataFilters() {
    return dataFilters;
  }

  /**
   * The DataFilters used to select which ranges to retrieve from the spreadsheet.
   * @param dataFilters dataFilters or {@code null} for none
   */
  public GetSpreadsheetByDataFilterRequest setDataFilters(java.util.List<DataFilter> dataFilters) {
    this.dataFilters = dataFilters;
    return this;
  }

  /**
   * True if grid data should be returned. This parameter is ignored if a field mask was set in the
   * request.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeGridData() {
    return includeGridData;
  }

  /**
   * True if grid data should be returned. This parameter is ignored if a field mask was set in the
   * request.
   * @param includeGridData includeGridData or {@code null} for none
   */
  public GetSpreadsheetByDataFilterRequest setIncludeGridData(java.lang.Boolean includeGridData) {
    this.includeGridData = includeGridData;
    return this;
  }

  @Override
  public GetSpreadsheetByDataFilterRequest set(String fieldName, Object value) {
    return (GetSpreadsheetByDataFilterRequest) super.set(fieldName, value);
  }

  @Override
  public GetSpreadsheetByDataFilterRequest clone() {
    return (GetSpreadsheetByDataFilterRequest) super.clone();
  }

}
