/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-09 at 22:34:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A group name and a list of items from the source data that should be placed in the group with
 * this name.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManualRuleGroup extends com.google.api.client.json.GenericJson {

  /**
   * The group name, which must be a string. Each group in a given ManualRule must have a unique
   * group name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExtendedValue groupName;

  /**
   * The items in the source data that should be placed into this group. Each item may be a string,
   * number, or boolean. Items may appear in at most one group within a given ManualRule. Items that
   * do not appear in any group will appear on their own.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExtendedValue> items;

  static {
    // hack to force ProGuard to consider ExtendedValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ExtendedValue.class);
  }

  /**
   * The group name, which must be a string. Each group in a given ManualRule must have a unique
   * group name.
   * @return value or {@code null} for none
   */
  public ExtendedValue getGroupName() {
    return groupName;
  }

  /**
   * The group name, which must be a string. Each group in a given ManualRule must have a unique
   * group name.
   * @param groupName groupName or {@code null} for none
   */
  public ManualRuleGroup setGroupName(ExtendedValue groupName) {
    this.groupName = groupName;
    return this;
  }

  /**
   * The items in the source data that should be placed into this group. Each item may be a string,
   * number, or boolean. Items may appear in at most one group within a given ManualRule. Items that
   * do not appear in any group will appear on their own.
   * @return value or {@code null} for none
   */
  public java.util.List<ExtendedValue> getItems() {
    return items;
  }

  /**
   * The items in the source data that should be placed into this group. Each item may be a string,
   * number, or boolean. Items may appear in at most one group within a given ManualRule. Items that
   * do not appear in any group will appear on their own.
   * @param items items or {@code null} for none
   */
  public ManualRuleGroup setItems(java.util.List<ExtendedValue> items) {
    this.items = items;
    return this;
  }

  @Override
  public ManualRuleGroup set(String fieldName, Object value) {
    return (ManualRuleGroup) super.set(fieldName, value);
  }

  @Override
  public ManualRuleGroup clone() {
    return (ManualRuleGroup) super.clone();
  }

}
