/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-13 at 23:36:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A condition that can evaluate to true or false. BooleanConditions are used by conditional
 * formatting, data validation, and the criteria in filters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BooleanCondition extends com.google.api.client.json.GenericJson {

  /**
   * The type of condition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The values of the condition. The number of supported values depends on the condition type.
   * Some support zero values, others one or two values, and ConditionType.ONE_OF_LIST supports an
   * arbitrary number of values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConditionValue> values;

  /**
   * The type of condition.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of condition.
   * @param type type or {@code null} for none
   */
  public BooleanCondition setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The values of the condition. The number of supported values depends on the condition type.
   * Some support zero values, others one or two values, and ConditionType.ONE_OF_LIST supports an
   * arbitrary number of values.
   * @return value or {@code null} for none
   */
  public java.util.List<ConditionValue> getValues() {
    return values;
  }

  /**
   * The values of the condition. The number of supported values depends on the condition type.
   * Some support zero values, others one or two values, and ConditionType.ONE_OF_LIST supports an
   * arbitrary number of values.
   * @param values values or {@code null} for none
   */
  public BooleanCondition setValues(java.util.List<ConditionValue> values) {
    this.values = values;
    return this;
  }

  @Override
  public BooleanCondition set(String fieldName, Object value) {
    return (BooleanCondition) super.set(fieldName, value);
  }

  @Override
  public BooleanCondition clone() {
    return (BooleanCondition) super.clone();
  }

}
