/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-11-07 at 07:01:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Formatting options for key value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KeyValueFormat extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the horizontal text positioning of key value. This field is optional. If not
   * specified, default positioning is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextPosition position;

  /**
   * Text formatting options for key value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextFormat textFormat;

  /**
   * Specifies the horizontal text positioning of key value. This field is optional. If not
   * specified, default positioning is used.
   * @return value or {@code null} for none
   */
  public TextPosition getPosition() {
    return position;
  }

  /**
   * Specifies the horizontal text positioning of key value. This field is optional. If not
   * specified, default positioning is used.
   * @param position position or {@code null} for none
   */
  public KeyValueFormat setPosition(TextPosition position) {
    this.position = position;
    return this;
  }

  /**
   * Text formatting options for key value.
   * @return value or {@code null} for none
   */
  public TextFormat getTextFormat() {
    return textFormat;
  }

  /**
   * Text formatting options for key value.
   * @param textFormat textFormat or {@code null} for none
   */
  public KeyValueFormat setTextFormat(TextFormat textFormat) {
    this.textFormat = textFormat;
    return this;
  }

  @Override
  public KeyValueFormat set(String fieldName, Object value) {
    return (KeyValueFormat) super.set(fieldName, value);
  }

  @Override
  public KeyValueFormat clone() {
    return (KeyValueFormat) super.clone();
  }

}
