/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-12 at 01:18:44 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Developer metadata associated with a location or object in a spreadsheet. Developer metadata may
 * be used to associate arbitrary data with various parts of a spreadsheet and will remain
 * associated at those locations as they move around and the spreadsheet is edited.  For example, if
 * developer metadata is associated with row 5 and another row is then subsequently inserted above
 * row 5, that original metadata will still be associated with the row it was first associated with
 * (what is now row 6). If the associated object is deleted its metadata is deleted too.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeveloperMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The location where the metadata is associated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeveloperMetadataLocation location;

  /**
   * The spreadsheet-scoped unique ID that identifies the metadata. IDs may be specified when
   * metadata is created, otherwise one will be randomly generated and assigned. Must be positive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer metadataId;

  /**
   * The metadata key. There may be multiple metadata in a spreadsheet with the same key.  Developer
   * metadata must always have a key specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataKey;

  /**
   * Data associated with the metadata's key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadataValue;

  /**
   * The metadata visibility.  Developer metadata must always have a visibility specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * The location where the metadata is associated.
   * @return value or {@code null} for none
   */
  public DeveloperMetadataLocation getLocation() {
    return location;
  }

  /**
   * The location where the metadata is associated.
   * @param location location or {@code null} for none
   */
  public DeveloperMetadata setLocation(DeveloperMetadataLocation location) {
    this.location = location;
    return this;
  }

  /**
   * The spreadsheet-scoped unique ID that identifies the metadata. IDs may be specified when
   * metadata is created, otherwise one will be randomly generated and assigned. Must be positive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMetadataId() {
    return metadataId;
  }

  /**
   * The spreadsheet-scoped unique ID that identifies the metadata. IDs may be specified when
   * metadata is created, otherwise one will be randomly generated and assigned. Must be positive.
   * @param metadataId metadataId or {@code null} for none
   */
  public DeveloperMetadata setMetadataId(java.lang.Integer metadataId) {
    this.metadataId = metadataId;
    return this;
  }

  /**
   * The metadata key. There may be multiple metadata in a spreadsheet with the same key.  Developer
   * metadata must always have a key specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataKey() {
    return metadataKey;
  }

  /**
   * The metadata key. There may be multiple metadata in a spreadsheet with the same key.  Developer
   * metadata must always have a key specified.
   * @param metadataKey metadataKey or {@code null} for none
   */
  public DeveloperMetadata setMetadataKey(java.lang.String metadataKey) {
    this.metadataKey = metadataKey;
    return this;
  }

  /**
   * Data associated with the metadata's key.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadataValue() {
    return metadataValue;
  }

  /**
   * Data associated with the metadata's key.
   * @param metadataValue metadataValue or {@code null} for none
   */
  public DeveloperMetadata setMetadataValue(java.lang.String metadataValue) {
    this.metadataValue = metadataValue;
    return this;
  }

  /**
   * The metadata visibility.  Developer metadata must always have a visibility specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * The metadata visibility.  Developer metadata must always have a visibility specified.
   * @param visibility visibility or {@code null} for none
   */
  public DeveloperMetadata setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public DeveloperMetadata set(String fieldName, Object value) {
    return (DeveloperMetadata) super.set(fieldName, value);
  }

  @Override
  public DeveloperMetadata clone() {
    return (DeveloperMetadata) super.clone();
  }

}
