/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-12 at 01:18:44 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Data in the grid, as well as metadata about the dimensions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GridData extends com.google.api.client.json.GenericJson {

  /**
   * Metadata about the requested columns in the grid, starting with the column in start_column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionProperties> columnMetadata;

  static {
    // hack to force ProGuard to consider DimensionProperties used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionProperties.class);
  }

  /**
   * The data in the grid, one entry per row, starting with the row in startRow. The values in
   * RowData will correspond to columns starting at start_column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RowData> rowData;

  static {
    // hack to force ProGuard to consider RowData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(RowData.class);
  }

  /**
   * Metadata about the requested rows in the grid, starting with the row in start_row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionProperties> rowMetadata;

  static {
    // hack to force ProGuard to consider DimensionProperties used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionProperties.class);
  }

  /**
   * The first column this GridData refers to, zero-based.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startColumn;

  /**
   * The first row this GridData refers to, zero-based.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startRow;

  /**
   * Metadata about the requested columns in the grid, starting with the column in start_column.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionProperties> getColumnMetadata() {
    return columnMetadata;
  }

  /**
   * Metadata about the requested columns in the grid, starting with the column in start_column.
   * @param columnMetadata columnMetadata or {@code null} for none
   */
  public GridData setColumnMetadata(java.util.List<DimensionProperties> columnMetadata) {
    this.columnMetadata = columnMetadata;
    return this;
  }

  /**
   * The data in the grid, one entry per row, starting with the row in startRow. The values in
   * RowData will correspond to columns starting at start_column.
   * @return value or {@code null} for none
   */
  public java.util.List<RowData> getRowData() {
    return rowData;
  }

  /**
   * The data in the grid, one entry per row, starting with the row in startRow. The values in
   * RowData will correspond to columns starting at start_column.
   * @param rowData rowData or {@code null} for none
   */
  public GridData setRowData(java.util.List<RowData> rowData) {
    this.rowData = rowData;
    return this;
  }

  /**
   * Metadata about the requested rows in the grid, starting with the row in start_row.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionProperties> getRowMetadata() {
    return rowMetadata;
  }

  /**
   * Metadata about the requested rows in the grid, starting with the row in start_row.
   * @param rowMetadata rowMetadata or {@code null} for none
   */
  public GridData setRowMetadata(java.util.List<DimensionProperties> rowMetadata) {
    this.rowMetadata = rowMetadata;
    return this;
  }

  /**
   * The first column this GridData refers to, zero-based.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartColumn() {
    return startColumn;
  }

  /**
   * The first column this GridData refers to, zero-based.
   * @param startColumn startColumn or {@code null} for none
   */
  public GridData setStartColumn(java.lang.Integer startColumn) {
    this.startColumn = startColumn;
    return this;
  }

  /**
   * The first row this GridData refers to, zero-based.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartRow() {
    return startRow;
  }

  /**
   * The first row this GridData refers to, zero-based.
   * @param startRow startRow or {@code null} for none
   */
  public GridData setStartRow(java.lang.Integer startRow) {
    this.startRow = startRow;
    return this;
  }

  @Override
  public GridData set(String fieldName, Object value) {
    return (GridData) super.set(fieldName, value);
  }

  @Override
  public GridData clone() {
    return (GridData) super.clone();
  }

}
