/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-26 at 05:02:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Deletes a group over the specified range by decrementing the depth of the dimensions in the
 * range.
 *
 * For example, assume the sheet has a depth-1 group over B:E and a depth-2 group over C:D. Deleting
 * a group over D:E leaves the sheet with a depth-1 group over B:D and a depth-2 group over C:C.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteDimensionGroupRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range of the group to be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange range;

  /**
   * The range of the group to be deleted.
   * @return value or {@code null} for none
   */
  public DimensionRange getRange() {
    return range;
  }

  /**
   * The range of the group to be deleted.
   * @param range range or {@code null} for none
   */
  public DeleteDimensionGroupRequest setRange(DimensionRange range) {
    this.range = range;
    return this;
  }

  @Override
  public DeleteDimensionGroupRequest set(String fieldName, Object value) {
    return (DeleteDimensionGroupRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteDimensionGroupRequest clone() {
    return (DeleteDimensionGroupRequest) super.clone();
  }

}
