/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-26 at 05:02:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Removes rows within this range that contain values in the specified columns that are duplicates
 * of values in any previous row. Rows with identical values but different letter cases, formatting,
 * or formulas are considered to be duplicates.
 *
 * This request also removes duplicate rows hidden from view (for example, due to a filter). When
 * removing duplicates, the first instance of each duplicate row scanning from the top downwards is
 * kept in the resulting range. Content outside of the specified range isn't removed, and rows
 * considered duplicates do not have to be adjacent to each other in the range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteDuplicatesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The columns in the range to analyze for duplicate values. If no columns are selected then all
   * columns are analyzed for duplicates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionRange> comparisonColumns;

  /**
   * The range to remove duplicates rows from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The columns in the range to analyze for duplicate values. If no columns are selected then all
   * columns are analyzed for duplicates.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionRange> getComparisonColumns() {
    return comparisonColumns;
  }

  /**
   * The columns in the range to analyze for duplicate values. If no columns are selected then all
   * columns are analyzed for duplicates.
   * @param comparisonColumns comparisonColumns or {@code null} for none
   */
  public DeleteDuplicatesRequest setComparisonColumns(java.util.List<DimensionRange> comparisonColumns) {
    this.comparisonColumns = comparisonColumns;
    return this;
  }

  /**
   * The range to remove duplicates rows from.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range to remove duplicates rows from.
   * @param range range or {@code null} for none
   */
  public DeleteDuplicatesRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  @Override
  public DeleteDuplicatesRequest set(String fieldName, Object value) {
    return (DeleteDuplicatesRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteDuplicatesRequest clone() {
    return (DeleteDuplicatesRequest) super.clone();
  }

}
