/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-11 at 02:03:52 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Fills in more data based on existing data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoFillRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range to autofill. This will examine the range and detect the location that has data and
   * automatically fill that data in to the rest of the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The source and destination areas to autofill. This explicitly lists the source of the autofill
   * and where to extend that data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SourceAndDestination sourceAndDestination;

  /**
   * True if we should generate data with the "alternate" series. This differs based on the type and
   * amount of source data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useAlternateSeries;

  /**
   * The range to autofill. This will examine the range and detect the location that has data and
   * automatically fill that data in to the rest of the range.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range to autofill. This will examine the range and detect the location that has data and
   * automatically fill that data in to the rest of the range.
   * @param range range or {@code null} for none
   */
  public AutoFillRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The source and destination areas to autofill. This explicitly lists the source of the autofill
   * and where to extend that data.
   * @return value or {@code null} for none
   */
  public SourceAndDestination getSourceAndDestination() {
    return sourceAndDestination;
  }

  /**
   * The source and destination areas to autofill. This explicitly lists the source of the autofill
   * and where to extend that data.
   * @param sourceAndDestination sourceAndDestination or {@code null} for none
   */
  public AutoFillRequest setSourceAndDestination(SourceAndDestination sourceAndDestination) {
    this.sourceAndDestination = sourceAndDestination;
    return this;
  }

  /**
   * True if we should generate data with the "alternate" series. This differs based on the type and
   * amount of source data.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseAlternateSeries() {
    return useAlternateSeries;
  }

  /**
   * True if we should generate data with the "alternate" series. This differs based on the type and
   * amount of source data.
   * @param useAlternateSeries useAlternateSeries or {@code null} for none
   */
  public AutoFillRequest setUseAlternateSeries(java.lang.Boolean useAlternateSeries) {
    this.useAlternateSeries = useAlternateSeries;
    return this;
  }

  @Override
  public AutoFillRequest set(String fieldName, Object value) {
    return (AutoFillRequest) super.set(fieldName, value);
  }

  @Override
  public AutoFillRequest clone() {
    return (AutoFillRequest) super.clone();
  }

}
