/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-11 at 02:03:52 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A slicer in a sheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Slicer extends com.google.api.client.json.GenericJson {

  /**
   * The position of the slicer. Note that slicer can be positioned only on existing sheet. Also,
   * width and height of slicer can be automatically adjusted to keep it within permitted limits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedObjectPosition position;

  /**
   * The ID of the slicer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer slicerId;

  /**
   * The specification of the slicer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SlicerSpec spec;

  /**
   * The position of the slicer. Note that slicer can be positioned only on existing sheet. Also,
   * width and height of slicer can be automatically adjusted to keep it within permitted limits.
   * @return value or {@code null} for none
   */
  public EmbeddedObjectPosition getPosition() {
    return position;
  }

  /**
   * The position of the slicer. Note that slicer can be positioned only on existing sheet. Also,
   * width and height of slicer can be automatically adjusted to keep it within permitted limits.
   * @param position position or {@code null} for none
   */
  public Slicer setPosition(EmbeddedObjectPosition position) {
    this.position = position;
    return this;
  }

  /**
   * The ID of the slicer.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSlicerId() {
    return slicerId;
  }

  /**
   * The ID of the slicer.
   * @param slicerId slicerId or {@code null} for none
   */
  public Slicer setSlicerId(java.lang.Integer slicerId) {
    this.slicerId = slicerId;
    return this;
  }

  /**
   * The specification of the slicer.
   * @return value or {@code null} for none
   */
  public SlicerSpec getSpec() {
    return spec;
  }

  /**
   * The specification of the slicer.
   * @param spec spec or {@code null} for none
   */
  public Slicer setSpec(SlicerSpec spec) {
    this.spec = spec;
    return this;
  }

  @Override
  public Slicer set(String fieldName, Object value) {
    return (Slicer) super.set(fieldName, value);
  }

  @Override
  public Slicer clone() {
    return (Slicer) super.clone();
  }

}
