/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-11 at 22:00:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Unmerges cells in the given range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UnmergeCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range within which all cells should be unmerged. If the range spans multiple merges, all
   * will be unmerged. The range must not partially span any merge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The range within which all cells should be unmerged. If the range spans multiple merges, all
   * will be unmerged. The range must not partially span any merge.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range within which all cells should be unmerged. If the range spans multiple merges, all
   * will be unmerged. The range must not partially span any merge.
   * @param range range or {@code null} for none
   */
  public UnmergeCellsRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  @Override
  public UnmergeCellsRequest set(String fieldName, Object value) {
    return (UnmergeCellsRequest) super.set(fieldName, value);
  }

  @Override
  public UnmergeCellsRequest clone() {
    return (UnmergeCellsRequest) super.clone();
  }

}
