/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-15 at 17:17:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Copies data from the source to the destination.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CopyPasteRequest extends com.google.api.client.json.GenericJson {

  /**
   * The location to paste to. If the range covers a span that's a multiple of the source's height
   * or width, then the data will be repeated to fill in the destination range. If the range is
   * smaller than the source range, the entire source data will still be copied (beyond the end of
   * the destination range).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange destination;

  /**
   * How that data should be oriented when pasting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pasteOrientation;

  /**
   * What kind of data to paste.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pasteType;

  /**
   * The source range to copy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange source;

  /**
   * The location to paste to. If the range covers a span that's a multiple of the source's height
   * or width, then the data will be repeated to fill in the destination range. If the range is
   * smaller than the source range, the entire source data will still be copied (beyond the end of
   * the destination range).
   * @return value or {@code null} for none
   */
  public GridRange getDestination() {
    return destination;
  }

  /**
   * The location to paste to. If the range covers a span that's a multiple of the source's height
   * or width, then the data will be repeated to fill in the destination range. If the range is
   * smaller than the source range, the entire source data will still be copied (beyond the end of
   * the destination range).
   * @param destination destination or {@code null} for none
   */
  public CopyPasteRequest setDestination(GridRange destination) {
    this.destination = destination;
    return this;
  }

  /**
   * How that data should be oriented when pasting.
   * @return value or {@code null} for none
   */
  public java.lang.String getPasteOrientation() {
    return pasteOrientation;
  }

  /**
   * How that data should be oriented when pasting.
   * @param pasteOrientation pasteOrientation or {@code null} for none
   */
  public CopyPasteRequest setPasteOrientation(java.lang.String pasteOrientation) {
    this.pasteOrientation = pasteOrientation;
    return this;
  }

  /**
   * What kind of data to paste.
   * @return value or {@code null} for none
   */
  public java.lang.String getPasteType() {
    return pasteType;
  }

  /**
   * What kind of data to paste.
   * @param pasteType pasteType or {@code null} for none
   */
  public CopyPasteRequest setPasteType(java.lang.String pasteType) {
    this.pasteType = pasteType;
    return this;
  }

  /**
   * The source range to copy.
   * @return value or {@code null} for none
   */
  public GridRange getSource() {
    return source;
  }

  /**
   * The source range to copy.
   * @param source source or {@code null} for none
   */
  public CopyPasteRequest setSource(GridRange source) {
    this.source = source;
    return this;
  }

  @Override
  public CopyPasteRequest set(String fieldName, Object value) {
    return (CopyPasteRequest) super.set(fieldName, value);
  }

  @Override
  public CopyPasteRequest clone() {
    return (CopyPasteRequest) super.clone();
  }

}
