/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-15 at 17:18:03 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The location an object is overlaid on top of a grid.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OverlayPosition extends com.google.api.client.json.GenericJson {

  /**
   * The cell the object is anchored to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridCoordinate anchorCell;

  /**
   * The height of the object, in pixels. Defaults to 371.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer heightPixels;

  /**
   * The horizontal offset, in pixels, that the object is offset from the anchor cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer offsetXPixels;

  /**
   * The vertical offset, in pixels, that the object is offset from the anchor cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer offsetYPixels;

  /**
   * The width of the object, in pixels. Defaults to 600.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer widthPixels;

  /**
   * The cell the object is anchored to.
   * @return value or {@code null} for none
   */
  public GridCoordinate getAnchorCell() {
    return anchorCell;
  }

  /**
   * The cell the object is anchored to.
   * @param anchorCell anchorCell or {@code null} for none
   */
  public OverlayPosition setAnchorCell(GridCoordinate anchorCell) {
    this.anchorCell = anchorCell;
    return this;
  }

  /**
   * The height of the object, in pixels. Defaults to 371.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHeightPixels() {
    return heightPixels;
  }

  /**
   * The height of the object, in pixels. Defaults to 371.
   * @param heightPixels heightPixels or {@code null} for none
   */
  public OverlayPosition setHeightPixels(java.lang.Integer heightPixels) {
    this.heightPixels = heightPixels;
    return this;
  }

  /**
   * The horizontal offset, in pixels, that the object is offset from the anchor cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOffsetXPixels() {
    return offsetXPixels;
  }

  /**
   * The horizontal offset, in pixels, that the object is offset from the anchor cell.
   * @param offsetXPixels offsetXPixels or {@code null} for none
   */
  public OverlayPosition setOffsetXPixels(java.lang.Integer offsetXPixels) {
    this.offsetXPixels = offsetXPixels;
    return this;
  }

  /**
   * The vertical offset, in pixels, that the object is offset from the anchor cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOffsetYPixels() {
    return offsetYPixels;
  }

  /**
   * The vertical offset, in pixels, that the object is offset from the anchor cell.
   * @param offsetYPixels offsetYPixels or {@code null} for none
   */
  public OverlayPosition setOffsetYPixels(java.lang.Integer offsetYPixels) {
    this.offsetYPixels = offsetYPixels;
    return this;
  }

  /**
   * The width of the object, in pixels. Defaults to 600.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWidthPixels() {
    return widthPixels;
  }

  /**
   * The width of the object, in pixels. Defaults to 600.
   * @param widthPixels widthPixels or {@code null} for none
   */
  public OverlayPosition setWidthPixels(java.lang.Integer widthPixels) {
    this.widthPixels = widthPixels;
    return this;
  }

  @Override
  public OverlayPosition set(String fieldName, Object value) {
    return (OverlayPosition) super.set(fieldName, value);
  }

  @Override
  public OverlayPosition clone() {
    return (OverlayPosition) super.clone();
  }

}
