/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-27 at 18:38:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates properties of the named range with the specified namedRangeId.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateNamedRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated.  At least one field must be specified. The root `namedRange`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The named range to update with the new properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NamedRange namedRange;

  /**
   * The fields that should be updated.  At least one field must be specified. The root `namedRange`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated.  At least one field must be specified. The root `namedRange`
   * is implied and should not be specified. A single `"*"` can be used as short-hand for listing
   * every field.
   * @param fields fields or {@code null} for none
   */
  public UpdateNamedRangeRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The named range to update with the new properties.
   * @return value or {@code null} for none
   */
  public NamedRange getNamedRange() {
    return namedRange;
  }

  /**
   * The named range to update with the new properties.
   * @param namedRange namedRange or {@code null} for none
   */
  public UpdateNamedRangeRequest setNamedRange(NamedRange namedRange) {
    this.namedRange = namedRange;
    return this;
  }

  @Override
  public UpdateNamedRangeRequest set(String fieldName, Object value) {
    return (UpdateNamedRangeRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateNamedRangeRequest clone() {
    return (UpdateNamedRangeRequest) super.clone();
  }

}
