/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-27 at 18:37:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A combination of a source range and how to extend that source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceAndDestination extends com.google.api.client.json.GenericJson {

  /**
   * The dimension that data should be filled into.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimension;

  /**
   * The number of rows or columns that data should be filled into. Positive numbers expand beyond
   * the last row or last column of the source.  Negative numbers expand before the first row or
   * first column of the source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer fillLength;

  /**
   * The location of the data to use as the source of the autofill.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange source;

  /**
   * The dimension that data should be filled into.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimension() {
    return dimension;
  }

  /**
   * The dimension that data should be filled into.
   * @param dimension dimension or {@code null} for none
   */
  public SourceAndDestination setDimension(java.lang.String dimension) {
    this.dimension = dimension;
    return this;
  }

  /**
   * The number of rows or columns that data should be filled into. Positive numbers expand beyond
   * the last row or last column of the source.  Negative numbers expand before the first row or
   * first column of the source.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFillLength() {
    return fillLength;
  }

  /**
   * The number of rows or columns that data should be filled into. Positive numbers expand beyond
   * the last row or last column of the source.  Negative numbers expand before the first row or
   * first column of the source.
   * @param fillLength fillLength or {@code null} for none
   */
  public SourceAndDestination setFillLength(java.lang.Integer fillLength) {
    this.fillLength = fillLength;
    return this;
  }

  /**
   * The location of the data to use as the source of the autofill.
   * @return value or {@code null} for none
   */
  public GridRange getSource() {
    return source;
  }

  /**
   * The location of the data to use as the source of the autofill.
   * @param source source or {@code null} for none
   */
  public SourceAndDestination setSource(GridRange source) {
    this.source = source;
    return this;
  }

  @Override
  public SourceAndDestination set(String fieldName, Object value) {
    return (SourceAndDestination) super.set(fieldName, value);
  }

  @Override
  public SourceAndDestination clone() {
    return (SourceAndDestination) super.clone();
  }

}
