/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-06-27 at 18:37:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A single kind of update to apply to a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Request extends com.google.api.client.json.GenericJson {

  /**
   * Adds a chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddChartRequest addChart;

  /**
   * Adds a new conditional format rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddConditionalFormatRuleRequest addConditionalFormatRule;

  /**
   * Adds a filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddFilterViewRequest addFilterView;

  /**
   * Adds a named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddNamedRangeRequest addNamedRange;

  /**
   * Adds a protected range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddProtectedRangeRequest addProtectedRange;

  /**
   * Adds a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddSheetRequest addSheet;

  /**
   * Appends cells after the last row with data in a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppendCellsRequest appendCells;

  /**
   * Appends dimensions to the end of a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppendDimensionRequest appendDimension;

  /**
   * Automatically fills in more data based on existing data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoFillRequest autoFill;

  /**
   * Automatically resizes one or more dimensions based on the contents of the cells in that
   * dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoResizeDimensionsRequest autoResizeDimensions;

  /**
   * Clears the basic filter on a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClearBasicFilterRequest clearBasicFilter;

  /**
   * Copies data from one area and pastes it to another.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CopyPasteRequest copyPaste;

  /**
   * Cuts data from one area and pastes it to another.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CutPasteRequest cutPaste;

  /**
   * Deletes an existing conditional format rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteConditionalFormatRuleRequest deleteConditionalFormatRule;

  /**
   * Deletes rows or columns in a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteDimensionRequest deleteDimension;

  /**
   * Deletes an embedded object (e.g, chart, image) in a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteEmbeddedObjectRequest deleteEmbeddedObject;

  /**
   * Deletes a filter view from a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteFilterViewRequest deleteFilterView;

  /**
   * Deletes a named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteNamedRangeRequest deleteNamedRange;

  /**
   * Deletes a protected range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteProtectedRangeRequest deleteProtectedRange;

  /**
   * Deletes a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteSheetRequest deleteSheet;

  /**
   * Duplicates a filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DuplicateFilterViewRequest duplicateFilterView;

  /**
   * Duplicates a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DuplicateSheetRequest duplicateSheet;

  /**
   * Finds and replaces occurrences of some text with other text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FindReplaceRequest findReplace;

  /**
   * Inserts new rows or columns in a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertDimensionRequest insertDimension;

  /**
   * Merges cells together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MergeCellsRequest mergeCells;

  /**
   * Moves rows or columns to another location in a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MoveDimensionRequest moveDimension;

  /**
   * Pastes data (HTML or delimited) into a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PasteDataRequest pasteData;

  /**
   * Repeats a single cell across a range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepeatCellRequest repeatCell;

  /**
   * Sets the basic filter on a sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SetBasicFilterRequest setBasicFilter;

  /**
   * Sets data validation for one or more cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SetDataValidationRequest setDataValidation;

  /**
   * Sorts data in a range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SortRangeRequest sortRange;

  /**
   * Converts a column of text into many columns of text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextToColumnsRequest textToColumns;

  /**
   * Unmerges merged cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UnmergeCellsRequest unmergeCells;

  /**
   * Updates the borders in a range of cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateBordersRequest updateBorders;

  /**
   * Updates many cells at once.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateCellsRequest updateCells;

  /**
   * Updates a chart's specifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateChartSpecRequest updateChartSpec;

  /**
   * Updates an existing conditional format rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateConditionalFormatRuleRequest updateConditionalFormatRule;

  /**
   * Updates dimensions' properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateDimensionPropertiesRequest updateDimensionProperties;

  /**
   * Updates an embedded object's (e.g. chart, image) position.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateEmbeddedObjectPositionRequest updateEmbeddedObjectPosition;

  /**
   * Updates the properties of a filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateFilterViewRequest updateFilterView;

  /**
   * Updates a named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateNamedRangeRequest updateNamedRange;

  /**
   * Updates a protected range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateProtectedRangeRequest updateProtectedRange;

  /**
   * Updates a sheet's properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateSheetPropertiesRequest updateSheetProperties;

  /**
   * Updates the spreadsheet's properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateSpreadsheetPropertiesRequest updateSpreadsheetProperties;

  /**
   * Adds a chart.
   * @return value or {@code null} for none
   */
  public AddChartRequest getAddChart() {
    return addChart;
  }

  /**
   * Adds a chart.
   * @param addChart addChart or {@code null} for none
   */
  public Request setAddChart(AddChartRequest addChart) {
    this.addChart = addChart;
    return this;
  }

  /**
   * Adds a new conditional format rule.
   * @return value or {@code null} for none
   */
  public AddConditionalFormatRuleRequest getAddConditionalFormatRule() {
    return addConditionalFormatRule;
  }

  /**
   * Adds a new conditional format rule.
   * @param addConditionalFormatRule addConditionalFormatRule or {@code null} for none
   */
  public Request setAddConditionalFormatRule(AddConditionalFormatRuleRequest addConditionalFormatRule) {
    this.addConditionalFormatRule = addConditionalFormatRule;
    return this;
  }

  /**
   * Adds a filter view.
   * @return value or {@code null} for none
   */
  public AddFilterViewRequest getAddFilterView() {
    return addFilterView;
  }

  /**
   * Adds a filter view.
   * @param addFilterView addFilterView or {@code null} for none
   */
  public Request setAddFilterView(AddFilterViewRequest addFilterView) {
    this.addFilterView = addFilterView;
    return this;
  }

  /**
   * Adds a named range.
   * @return value or {@code null} for none
   */
  public AddNamedRangeRequest getAddNamedRange() {
    return addNamedRange;
  }

  /**
   * Adds a named range.
   * @param addNamedRange addNamedRange or {@code null} for none
   */
  public Request setAddNamedRange(AddNamedRangeRequest addNamedRange) {
    this.addNamedRange = addNamedRange;
    return this;
  }

  /**
   * Adds a protected range.
   * @return value or {@code null} for none
   */
  public AddProtectedRangeRequest getAddProtectedRange() {
    return addProtectedRange;
  }

  /**
   * Adds a protected range.
   * @param addProtectedRange addProtectedRange or {@code null} for none
   */
  public Request setAddProtectedRange(AddProtectedRangeRequest addProtectedRange) {
    this.addProtectedRange = addProtectedRange;
    return this;
  }

  /**
   * Adds a sheet.
   * @return value or {@code null} for none
   */
  public AddSheetRequest getAddSheet() {
    return addSheet;
  }

  /**
   * Adds a sheet.
   * @param addSheet addSheet or {@code null} for none
   */
  public Request setAddSheet(AddSheetRequest addSheet) {
    this.addSheet = addSheet;
    return this;
  }

  /**
   * Appends cells after the last row with data in a sheet.
   * @return value or {@code null} for none
   */
  public AppendCellsRequest getAppendCells() {
    return appendCells;
  }

  /**
   * Appends cells after the last row with data in a sheet.
   * @param appendCells appendCells or {@code null} for none
   */
  public Request setAppendCells(AppendCellsRequest appendCells) {
    this.appendCells = appendCells;
    return this;
  }

  /**
   * Appends dimensions to the end of a sheet.
   * @return value or {@code null} for none
   */
  public AppendDimensionRequest getAppendDimension() {
    return appendDimension;
  }

  /**
   * Appends dimensions to the end of a sheet.
   * @param appendDimension appendDimension or {@code null} for none
   */
  public Request setAppendDimension(AppendDimensionRequest appendDimension) {
    this.appendDimension = appendDimension;
    return this;
  }

  /**
   * Automatically fills in more data based on existing data.
   * @return value or {@code null} for none
   */
  public AutoFillRequest getAutoFill() {
    return autoFill;
  }

  /**
   * Automatically fills in more data based on existing data.
   * @param autoFill autoFill or {@code null} for none
   */
  public Request setAutoFill(AutoFillRequest autoFill) {
    this.autoFill = autoFill;
    return this;
  }

  /**
   * Automatically resizes one or more dimensions based on the contents of the cells in that
   * dimension.
   * @return value or {@code null} for none
   */
  public AutoResizeDimensionsRequest getAutoResizeDimensions() {
    return autoResizeDimensions;
  }

  /**
   * Automatically resizes one or more dimensions based on the contents of the cells in that
   * dimension.
   * @param autoResizeDimensions autoResizeDimensions or {@code null} for none
   */
  public Request setAutoResizeDimensions(AutoResizeDimensionsRequest autoResizeDimensions) {
    this.autoResizeDimensions = autoResizeDimensions;
    return this;
  }

  /**
   * Clears the basic filter on a sheet.
   * @return value or {@code null} for none
   */
  public ClearBasicFilterRequest getClearBasicFilter() {
    return clearBasicFilter;
  }

  /**
   * Clears the basic filter on a sheet.
   * @param clearBasicFilter clearBasicFilter or {@code null} for none
   */
  public Request setClearBasicFilter(ClearBasicFilterRequest clearBasicFilter) {
    this.clearBasicFilter = clearBasicFilter;
    return this;
  }

  /**
   * Copies data from one area and pastes it to another.
   * @return value or {@code null} for none
   */
  public CopyPasteRequest getCopyPaste() {
    return copyPaste;
  }

  /**
   * Copies data from one area and pastes it to another.
   * @param copyPaste copyPaste or {@code null} for none
   */
  public Request setCopyPaste(CopyPasteRequest copyPaste) {
    this.copyPaste = copyPaste;
    return this;
  }

  /**
   * Cuts data from one area and pastes it to another.
   * @return value or {@code null} for none
   */
  public CutPasteRequest getCutPaste() {
    return cutPaste;
  }

  /**
   * Cuts data from one area and pastes it to another.
   * @param cutPaste cutPaste or {@code null} for none
   */
  public Request setCutPaste(CutPasteRequest cutPaste) {
    this.cutPaste = cutPaste;
    return this;
  }

  /**
   * Deletes an existing conditional format rule.
   * @return value or {@code null} for none
   */
  public DeleteConditionalFormatRuleRequest getDeleteConditionalFormatRule() {
    return deleteConditionalFormatRule;
  }

  /**
   * Deletes an existing conditional format rule.
   * @param deleteConditionalFormatRule deleteConditionalFormatRule or {@code null} for none
   */
  public Request setDeleteConditionalFormatRule(DeleteConditionalFormatRuleRequest deleteConditionalFormatRule) {
    this.deleteConditionalFormatRule = deleteConditionalFormatRule;
    return this;
  }

  /**
   * Deletes rows or columns in a sheet.
   * @return value or {@code null} for none
   */
  public DeleteDimensionRequest getDeleteDimension() {
    return deleteDimension;
  }

  /**
   * Deletes rows or columns in a sheet.
   * @param deleteDimension deleteDimension or {@code null} for none
   */
  public Request setDeleteDimension(DeleteDimensionRequest deleteDimension) {
    this.deleteDimension = deleteDimension;
    return this;
  }

  /**
   * Deletes an embedded object (e.g, chart, image) in a sheet.
   * @return value or {@code null} for none
   */
  public DeleteEmbeddedObjectRequest getDeleteEmbeddedObject() {
    return deleteEmbeddedObject;
  }

  /**
   * Deletes an embedded object (e.g, chart, image) in a sheet.
   * @param deleteEmbeddedObject deleteEmbeddedObject or {@code null} for none
   */
  public Request setDeleteEmbeddedObject(DeleteEmbeddedObjectRequest deleteEmbeddedObject) {
    this.deleteEmbeddedObject = deleteEmbeddedObject;
    return this;
  }

  /**
   * Deletes a filter view from a sheet.
   * @return value or {@code null} for none
   */
  public DeleteFilterViewRequest getDeleteFilterView() {
    return deleteFilterView;
  }

  /**
   * Deletes a filter view from a sheet.
   * @param deleteFilterView deleteFilterView or {@code null} for none
   */
  public Request setDeleteFilterView(DeleteFilterViewRequest deleteFilterView) {
    this.deleteFilterView = deleteFilterView;
    return this;
  }

  /**
   * Deletes a named range.
   * @return value or {@code null} for none
   */
  public DeleteNamedRangeRequest getDeleteNamedRange() {
    return deleteNamedRange;
  }

  /**
   * Deletes a named range.
   * @param deleteNamedRange deleteNamedRange or {@code null} for none
   */
  public Request setDeleteNamedRange(DeleteNamedRangeRequest deleteNamedRange) {
    this.deleteNamedRange = deleteNamedRange;
    return this;
  }

  /**
   * Deletes a protected range.
   * @return value or {@code null} for none
   */
  public DeleteProtectedRangeRequest getDeleteProtectedRange() {
    return deleteProtectedRange;
  }

  /**
   * Deletes a protected range.
   * @param deleteProtectedRange deleteProtectedRange or {@code null} for none
   */
  public Request setDeleteProtectedRange(DeleteProtectedRangeRequest deleteProtectedRange) {
    this.deleteProtectedRange = deleteProtectedRange;
    return this;
  }

  /**
   * Deletes a sheet.
   * @return value or {@code null} for none
   */
  public DeleteSheetRequest getDeleteSheet() {
    return deleteSheet;
  }

  /**
   * Deletes a sheet.
   * @param deleteSheet deleteSheet or {@code null} for none
   */
  public Request setDeleteSheet(DeleteSheetRequest deleteSheet) {
    this.deleteSheet = deleteSheet;
    return this;
  }

  /**
   * Duplicates a filter view.
   * @return value or {@code null} for none
   */
  public DuplicateFilterViewRequest getDuplicateFilterView() {
    return duplicateFilterView;
  }

  /**
   * Duplicates a filter view.
   * @param duplicateFilterView duplicateFilterView or {@code null} for none
   */
  public Request setDuplicateFilterView(DuplicateFilterViewRequest duplicateFilterView) {
    this.duplicateFilterView = duplicateFilterView;
    return this;
  }

  /**
   * Duplicates a sheet.
   * @return value or {@code null} for none
   */
  public DuplicateSheetRequest getDuplicateSheet() {
    return duplicateSheet;
  }

  /**
   * Duplicates a sheet.
   * @param duplicateSheet duplicateSheet or {@code null} for none
   */
  public Request setDuplicateSheet(DuplicateSheetRequest duplicateSheet) {
    this.duplicateSheet = duplicateSheet;
    return this;
  }

  /**
   * Finds and replaces occurrences of some text with other text.
   * @return value or {@code null} for none
   */
  public FindReplaceRequest getFindReplace() {
    return findReplace;
  }

  /**
   * Finds and replaces occurrences of some text with other text.
   * @param findReplace findReplace or {@code null} for none
   */
  public Request setFindReplace(FindReplaceRequest findReplace) {
    this.findReplace = findReplace;
    return this;
  }

  /**
   * Inserts new rows or columns in a sheet.
   * @return value or {@code null} for none
   */
  public InsertDimensionRequest getInsertDimension() {
    return insertDimension;
  }

  /**
   * Inserts new rows or columns in a sheet.
   * @param insertDimension insertDimension or {@code null} for none
   */
  public Request setInsertDimension(InsertDimensionRequest insertDimension) {
    this.insertDimension = insertDimension;
    return this;
  }

  /**
   * Merges cells together.
   * @return value or {@code null} for none
   */
  public MergeCellsRequest getMergeCells() {
    return mergeCells;
  }

  /**
   * Merges cells together.
   * @param mergeCells mergeCells or {@code null} for none
   */
  public Request setMergeCells(MergeCellsRequest mergeCells) {
    this.mergeCells = mergeCells;
    return this;
  }

  /**
   * Moves rows or columns to another location in a sheet.
   * @return value or {@code null} for none
   */
  public MoveDimensionRequest getMoveDimension() {
    return moveDimension;
  }

  /**
   * Moves rows or columns to another location in a sheet.
   * @param moveDimension moveDimension or {@code null} for none
   */
  public Request setMoveDimension(MoveDimensionRequest moveDimension) {
    this.moveDimension = moveDimension;
    return this;
  }

  /**
   * Pastes data (HTML or delimited) into a sheet.
   * @return value or {@code null} for none
   */
  public PasteDataRequest getPasteData() {
    return pasteData;
  }

  /**
   * Pastes data (HTML or delimited) into a sheet.
   * @param pasteData pasteData or {@code null} for none
   */
  public Request setPasteData(PasteDataRequest pasteData) {
    this.pasteData = pasteData;
    return this;
  }

  /**
   * Repeats a single cell across a range.
   * @return value or {@code null} for none
   */
  public RepeatCellRequest getRepeatCell() {
    return repeatCell;
  }

  /**
   * Repeats a single cell across a range.
   * @param repeatCell repeatCell or {@code null} for none
   */
  public Request setRepeatCell(RepeatCellRequest repeatCell) {
    this.repeatCell = repeatCell;
    return this;
  }

  /**
   * Sets the basic filter on a sheet.
   * @return value or {@code null} for none
   */
  public SetBasicFilterRequest getSetBasicFilter() {
    return setBasicFilter;
  }

  /**
   * Sets the basic filter on a sheet.
   * @param setBasicFilter setBasicFilter or {@code null} for none
   */
  public Request setSetBasicFilter(SetBasicFilterRequest setBasicFilter) {
    this.setBasicFilter = setBasicFilter;
    return this;
  }

  /**
   * Sets data validation for one or more cells.
   * @return value or {@code null} for none
   */
  public SetDataValidationRequest getSetDataValidation() {
    return setDataValidation;
  }

  /**
   * Sets data validation for one or more cells.
   * @param setDataValidation setDataValidation or {@code null} for none
   */
  public Request setSetDataValidation(SetDataValidationRequest setDataValidation) {
    this.setDataValidation = setDataValidation;
    return this;
  }

  /**
   * Sorts data in a range.
   * @return value or {@code null} for none
   */
  public SortRangeRequest getSortRange() {
    return sortRange;
  }

  /**
   * Sorts data in a range.
   * @param sortRange sortRange or {@code null} for none
   */
  public Request setSortRange(SortRangeRequest sortRange) {
    this.sortRange = sortRange;
    return this;
  }

  /**
   * Converts a column of text into many columns of text.
   * @return value or {@code null} for none
   */
  public TextToColumnsRequest getTextToColumns() {
    return textToColumns;
  }

  /**
   * Converts a column of text into many columns of text.
   * @param textToColumns textToColumns or {@code null} for none
   */
  public Request setTextToColumns(TextToColumnsRequest textToColumns) {
    this.textToColumns = textToColumns;
    return this;
  }

  /**
   * Unmerges merged cells.
   * @return value or {@code null} for none
   */
  public UnmergeCellsRequest getUnmergeCells() {
    return unmergeCells;
  }

  /**
   * Unmerges merged cells.
   * @param unmergeCells unmergeCells or {@code null} for none
   */
  public Request setUnmergeCells(UnmergeCellsRequest unmergeCells) {
    this.unmergeCells = unmergeCells;
    return this;
  }

  /**
   * Updates the borders in a range of cells.
   * @return value or {@code null} for none
   */
  public UpdateBordersRequest getUpdateBorders() {
    return updateBorders;
  }

  /**
   * Updates the borders in a range of cells.
   * @param updateBorders updateBorders or {@code null} for none
   */
  public Request setUpdateBorders(UpdateBordersRequest updateBorders) {
    this.updateBorders = updateBorders;
    return this;
  }

  /**
   * Updates many cells at once.
   * @return value or {@code null} for none
   */
  public UpdateCellsRequest getUpdateCells() {
    return updateCells;
  }

  /**
   * Updates many cells at once.
   * @param updateCells updateCells or {@code null} for none
   */
  public Request setUpdateCells(UpdateCellsRequest updateCells) {
    this.updateCells = updateCells;
    return this;
  }

  /**
   * Updates a chart's specifications.
   * @return value or {@code null} for none
   */
  public UpdateChartSpecRequest getUpdateChartSpec() {
    return updateChartSpec;
  }

  /**
   * Updates a chart's specifications.
   * @param updateChartSpec updateChartSpec or {@code null} for none
   */
  public Request setUpdateChartSpec(UpdateChartSpecRequest updateChartSpec) {
    this.updateChartSpec = updateChartSpec;
    return this;
  }

  /**
   * Updates an existing conditional format rule.
   * @return value or {@code null} for none
   */
  public UpdateConditionalFormatRuleRequest getUpdateConditionalFormatRule() {
    return updateConditionalFormatRule;
  }

  /**
   * Updates an existing conditional format rule.
   * @param updateConditionalFormatRule updateConditionalFormatRule or {@code null} for none
   */
  public Request setUpdateConditionalFormatRule(UpdateConditionalFormatRuleRequest updateConditionalFormatRule) {
    this.updateConditionalFormatRule = updateConditionalFormatRule;
    return this;
  }

  /**
   * Updates dimensions' properties.
   * @return value or {@code null} for none
   */
  public UpdateDimensionPropertiesRequest getUpdateDimensionProperties() {
    return updateDimensionProperties;
  }

  /**
   * Updates dimensions' properties.
   * @param updateDimensionProperties updateDimensionProperties or {@code null} for none
   */
  public Request setUpdateDimensionProperties(UpdateDimensionPropertiesRequest updateDimensionProperties) {
    this.updateDimensionProperties = updateDimensionProperties;
    return this;
  }

  /**
   * Updates an embedded object's (e.g. chart, image) position.
   * @return value or {@code null} for none
   */
  public UpdateEmbeddedObjectPositionRequest getUpdateEmbeddedObjectPosition() {
    return updateEmbeddedObjectPosition;
  }

  /**
   * Updates an embedded object's (e.g. chart, image) position.
   * @param updateEmbeddedObjectPosition updateEmbeddedObjectPosition or {@code null} for none
   */
  public Request setUpdateEmbeddedObjectPosition(UpdateEmbeddedObjectPositionRequest updateEmbeddedObjectPosition) {
    this.updateEmbeddedObjectPosition = updateEmbeddedObjectPosition;
    return this;
  }

  /**
   * Updates the properties of a filter view.
   * @return value or {@code null} for none
   */
  public UpdateFilterViewRequest getUpdateFilterView() {
    return updateFilterView;
  }

  /**
   * Updates the properties of a filter view.
   * @param updateFilterView updateFilterView or {@code null} for none
   */
  public Request setUpdateFilterView(UpdateFilterViewRequest updateFilterView) {
    this.updateFilterView = updateFilterView;
    return this;
  }

  /**
   * Updates a named range.
   * @return value or {@code null} for none
   */
  public UpdateNamedRangeRequest getUpdateNamedRange() {
    return updateNamedRange;
  }

  /**
   * Updates a named range.
   * @param updateNamedRange updateNamedRange or {@code null} for none
   */
  public Request setUpdateNamedRange(UpdateNamedRangeRequest updateNamedRange) {
    this.updateNamedRange = updateNamedRange;
    return this;
  }

  /**
   * Updates a protected range.
   * @return value or {@code null} for none
   */
  public UpdateProtectedRangeRequest getUpdateProtectedRange() {
    return updateProtectedRange;
  }

  /**
   * Updates a protected range.
   * @param updateProtectedRange updateProtectedRange or {@code null} for none
   */
  public Request setUpdateProtectedRange(UpdateProtectedRangeRequest updateProtectedRange) {
    this.updateProtectedRange = updateProtectedRange;
    return this;
  }

  /**
   * Updates a sheet's properties.
   * @return value or {@code null} for none
   */
  public UpdateSheetPropertiesRequest getUpdateSheetProperties() {
    return updateSheetProperties;
  }

  /**
   * Updates a sheet's properties.
   * @param updateSheetProperties updateSheetProperties or {@code null} for none
   */
  public Request setUpdateSheetProperties(UpdateSheetPropertiesRequest updateSheetProperties) {
    this.updateSheetProperties = updateSheetProperties;
    return this;
  }

  /**
   * Updates the spreadsheet's properties.
   * @return value or {@code null} for none
   */
  public UpdateSpreadsheetPropertiesRequest getUpdateSpreadsheetProperties() {
    return updateSpreadsheetProperties;
  }

  /**
   * Updates the spreadsheet's properties.
   * @param updateSpreadsheetProperties updateSpreadsheetProperties or {@code null} for none
   */
  public Request setUpdateSpreadsheetProperties(UpdateSpreadsheetPropertiesRequest updateSpreadsheetProperties) {
    this.updateSpreadsheetProperties = updateSpreadsheetProperties;
    return this;
  }

  @Override
  public Request set(String fieldName, Object value) {
    return (Request) super.set(fieldName, value);
  }

  @Override
  public Request clone() {
    return (Request) super.clone();
  }

}
