/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * AffineTransform uses a 3x3 matrix with an implied last row of [ 0 0 1 ] to transform source
 * coordinates (x,y) into destination coordinates (x', y') according to: x' x = shear_y scale_y
 * translate_y 1 [ 1 ] After transformation, x' = scale_x * x + shear_x * y + translate_x; y' =
 * scale_y * y + shear_y * x + translate_y; This message is therefore composed of these six matrix
 * elements.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AffineTransform extends com.google.api.client.json.GenericJson {

  /**
   * The X coordinate scaling element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double scaleX;

  /**
   * The Y coordinate scaling element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double scaleY;

  /**
   * The X coordinate shearing element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double shearX;

  /**
   * The Y coordinate shearing element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double shearY;

  /**
   * The X coordinate translation element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double translateX;

  /**
   * The Y coordinate translation element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double translateY;

  /**
   * The units for translate elements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unit;

  /**
   * The X coordinate scaling element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getScaleX() {
    return scaleX;
  }

  /**
   * The X coordinate scaling element.
   * @param scaleX scaleX or {@code null} for none
   */
  public AffineTransform setScaleX(java.lang.Double scaleX) {
    this.scaleX = scaleX;
    return this;
  }

  /**
   * The Y coordinate scaling element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getScaleY() {
    return scaleY;
  }

  /**
   * The Y coordinate scaling element.
   * @param scaleY scaleY or {@code null} for none
   */
  public AffineTransform setScaleY(java.lang.Double scaleY) {
    this.scaleY = scaleY;
    return this;
  }

  /**
   * The X coordinate shearing element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getShearX() {
    return shearX;
  }

  /**
   * The X coordinate shearing element.
   * @param shearX shearX or {@code null} for none
   */
  public AffineTransform setShearX(java.lang.Double shearX) {
    this.shearX = shearX;
    return this;
  }

  /**
   * The Y coordinate shearing element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getShearY() {
    return shearY;
  }

  /**
   * The Y coordinate shearing element.
   * @param shearY shearY or {@code null} for none
   */
  public AffineTransform setShearY(java.lang.Double shearY) {
    this.shearY = shearY;
    return this;
  }

  /**
   * The X coordinate translation element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getTranslateX() {
    return translateX;
  }

  /**
   * The X coordinate translation element.
   * @param translateX translateX or {@code null} for none
   */
  public AffineTransform setTranslateX(java.lang.Double translateX) {
    this.translateX = translateX;
    return this;
  }

  /**
   * The Y coordinate translation element.
   * @return value or {@code null} for none
   */
  public java.lang.Double getTranslateY() {
    return translateY;
  }

  /**
   * The Y coordinate translation element.
   * @param translateY translateY or {@code null} for none
   */
  public AffineTransform setTranslateY(java.lang.Double translateY) {
    this.translateY = translateY;
    return this;
  }

  /**
   * The units for translate elements.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnit() {
    return unit;
  }

  /**
   * The units for translate elements.
   * @param unit unit or {@code null} for none
   */
  public AffineTransform setUnit(java.lang.String unit) {
    this.unit = unit;
    return this;
  }

  @Override
  public AffineTransform set(String fieldName, Object value) {
    return (AffineTransform) super.set(fieldName, value);
  }

  @Override
  public AffineTransform clone() {
    return (AffineTransform) super.clone();
  }

}
