/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Creates a line.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateLineRequest extends com.google.api.client.json.GenericJson {

  /**
   * The category of the line to be created. The exact line type created is determined based on the
   * category and how it's routed to connect to other page elements. If you specify both a
   * `category` and a `line_category`, the `category` takes precedence. If you do not specify a
   * value for `category`, but specify a value for `line_category`, then the specified
   * `line_category` value is used. If you do not specify either, then STRAIGHT is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String category;

  /**
   * The element properties for the line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageElementProperties elementProperties;

  /**
   * The category of the line to be created. *Deprecated*: use `category` instead. The exact line
   * type created is determined based on the category and how it's routed to connect to other page
   * elements. If you specify both a `category` and a `line_category`, the `category` takes
   * precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineCategory;

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The category of the line to be created. The exact line type created is determined based on the
   * category and how it's routed to connect to other page elements. If you specify both a
   * `category` and a `line_category`, the `category` takes precedence. If you do not specify a
   * value for `category`, but specify a value for `line_category`, then the specified
   * `line_category` value is used. If you do not specify either, then STRAIGHT is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategory() {
    return category;
  }

  /**
   * The category of the line to be created. The exact line type created is determined based on the
   * category and how it's routed to connect to other page elements. If you specify both a
   * `category` and a `line_category`, the `category` takes precedence. If you do not specify a
   * value for `category`, but specify a value for `line_category`, then the specified
   * `line_category` value is used. If you do not specify either, then STRAIGHT is used.
   * @param category category or {@code null} for none
   */
  public CreateLineRequest setCategory(java.lang.String category) {
    this.category = category;
    return this;
  }

  /**
   * The element properties for the line.
   * @return value or {@code null} for none
   */
  public PageElementProperties getElementProperties() {
    return elementProperties;
  }

  /**
   * The element properties for the line.
   * @param elementProperties elementProperties or {@code null} for none
   */
  public CreateLineRequest setElementProperties(PageElementProperties elementProperties) {
    this.elementProperties = elementProperties;
    return this;
  }

  /**
   * The category of the line to be created. *Deprecated*: use `category` instead. The exact line
   * type created is determined based on the category and how it's routed to connect to other page
   * elements. If you specify both a `category` and a `line_category`, the `category` takes
   * precedence.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineCategory() {
    return lineCategory;
  }

  /**
   * The category of the line to be created. *Deprecated*: use `category` instead. The exact line
   * type created is determined based on the category and how it's routed to connect to other page
   * elements. If you specify both a `category` and a `line_category`, the `category` takes
   * precedence.
   * @param lineCategory lineCategory or {@code null} for none
   */
  public CreateLineRequest setLineCategory(java.lang.String lineCategory) {
    this.lineCategory = lineCategory;
    return this;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * @param objectId objectId or {@code null} for none
   */
  public CreateLineRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  @Override
  public CreateLineRequest set(String fieldName, Object value) {
    return (CreateLineRequest) super.set(fieldName, value);
  }

  @Override
  public CreateLineRequest clone() {
    return (CreateLineRequest) super.clone();
  }

}
