/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Creates bullets for all of the paragraphs that overlap with the given text index range. The
 * nesting level of each paragraph will be determined by counting leading tabs in front of each
 * paragraph. To avoid excess space between the bullet and the corresponding paragraph, these
 * leading tabs are removed by this request. This may change the indices of parts of the text. If
 * the paragraph immediately before paragraphs being updated is in a list with a matching preset,
 * the paragraphs being updated are added to that preceding list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateParagraphBulletsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The kinds of bullet glyphs to be used. Defaults to the `BULLET_DISC_CIRCLE_SQUARE` preset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bulletPreset;

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation cellLocation;

  /**
   * The object ID of the shape or table containing the text to add bullets to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The range of text to apply the bullet presets to, based on TextElement indexes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range textRange;

  /**
   * The kinds of bullet glyphs to be used. Defaults to the `BULLET_DISC_CIRCLE_SQUARE` preset.
   * @return value or {@code null} for none
   */
  public java.lang.String getBulletPreset() {
    return bulletPreset;
  }

  /**
   * The kinds of bullet glyphs to be used. Defaults to the `BULLET_DISC_CIRCLE_SQUARE` preset.
   * @param bulletPreset bulletPreset or {@code null} for none
   */
  public CreateParagraphBulletsRequest setBulletPreset(java.lang.String bulletPreset) {
    this.bulletPreset = bulletPreset;
    return this;
  }

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * @return value or {@code null} for none
   */
  public TableCellLocation getCellLocation() {
    return cellLocation;
  }

  /**
   * The optional table cell location if the text to be modified is in a table cell. If present, the
   * object_id must refer to a table.
   * @param cellLocation cellLocation or {@code null} for none
   */
  public CreateParagraphBulletsRequest setCellLocation(TableCellLocation cellLocation) {
    this.cellLocation = cellLocation;
    return this;
  }

  /**
   * The object ID of the shape or table containing the text to add bullets to.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the shape or table containing the text to add bullets to.
   * @param objectId objectId or {@code null} for none
   */
  public CreateParagraphBulletsRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The range of text to apply the bullet presets to, based on TextElement indexes.
   * @return value or {@code null} for none
   */
  public Range getTextRange() {
    return textRange;
  }

  /**
   * The range of text to apply the bullet presets to, based on TextElement indexes.
   * @param textRange textRange or {@code null} for none
   */
  public CreateParagraphBulletsRequest setTextRange(Range textRange) {
    this.textRange = textRange;
    return this;
  }

  @Override
  public CreateParagraphBulletsRequest set(String fieldName, Object value) {
    return (CreateParagraphBulletsRequest) super.set(fieldName, value);
  }

  @Override
  public CreateParagraphBulletsRequest clone() {
    return (CreateParagraphBulletsRequest) super.clone();
  }

}
