/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Creates a slide.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateSlideRequest extends com.google.api.client.json.GenericJson {

  /**
   * The optional zero-based index indicating where to insert the slides. If you don't specify an
   * index, the slide is created at the end.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer insertionIndex;

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The ID length must be between 5 and 50 characters,
   * inclusive. If you don't specify an ID, a unique one is generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * An optional list of object ID mappings from the placeholder(s) on the layout to the
   * placeholders that are created on the slide from the specified layout. Can only be used when
   * `slide_layout_reference` is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LayoutPlaceholderIdMapping> placeholderIdMappings;

  /**
   * Layout reference of the slide to be inserted, based on the *current master*, which is one of
   * the following: - The master of the previous slide index. - The master of the first slide, if
   * the insertion_index is zero. - The first master in the presentation, if there are no slides. If
   * the LayoutReference is not found in the current master, a 400 bad request error is returned. If
   * you don't specify a layout reference, the slide uses the predefined `BLANK` layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LayoutReference slideLayoutReference;

  /**
   * The optional zero-based index indicating where to insert the slides. If you don't specify an
   * index, the slide is created at the end.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInsertionIndex() {
    return insertionIndex;
  }

  /**
   * The optional zero-based index indicating where to insert the slides. If you don't specify an
   * index, the slide is created at the end.
   * @param insertionIndex insertionIndex or {@code null} for none
   */
  public CreateSlideRequest setInsertionIndex(java.lang.Integer insertionIndex) {
    this.insertionIndex = insertionIndex;
    return this;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The ID length must be between 5 and 50 characters,
   * inclusive. If you don't specify an ID, a unique one is generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The ID length must be between 5 and 50 characters,
   * inclusive. If you don't specify an ID, a unique one is generated.
   * @param objectId objectId or {@code null} for none
   */
  public CreateSlideRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * An optional list of object ID mappings from the placeholder(s) on the layout to the
   * placeholders that are created on the slide from the specified layout. Can only be used when
   * `slide_layout_reference` is specified.
   * @return value or {@code null} for none
   */
  public java.util.List<LayoutPlaceholderIdMapping> getPlaceholderIdMappings() {
    return placeholderIdMappings;
  }

  /**
   * An optional list of object ID mappings from the placeholder(s) on the layout to the
   * placeholders that are created on the slide from the specified layout. Can only be used when
   * `slide_layout_reference` is specified.
   * @param placeholderIdMappings placeholderIdMappings or {@code null} for none
   */
  public CreateSlideRequest setPlaceholderIdMappings(java.util.List<LayoutPlaceholderIdMapping> placeholderIdMappings) {
    this.placeholderIdMappings = placeholderIdMappings;
    return this;
  }

  /**
   * Layout reference of the slide to be inserted, based on the *current master*, which is one of
   * the following: - The master of the previous slide index. - The master of the first slide, if
   * the insertion_index is zero. - The first master in the presentation, if there are no slides. If
   * the LayoutReference is not found in the current master, a 400 bad request error is returned. If
   * you don't specify a layout reference, the slide uses the predefined `BLANK` layout.
   * @return value or {@code null} for none
   */
  public LayoutReference getSlideLayoutReference() {
    return slideLayoutReference;
  }

  /**
   * Layout reference of the slide to be inserted, based on the *current master*, which is one of
   * the following: - The master of the previous slide index. - The master of the first slide, if
   * the insertion_index is zero. - The first master in the presentation, if there are no slides. If
   * the LayoutReference is not found in the current master, a 400 bad request error is returned. If
   * you don't specify a layout reference, the slide uses the predefined `BLANK` layout.
   * @param slideLayoutReference slideLayoutReference or {@code null} for none
   */
  public CreateSlideRequest setSlideLayoutReference(LayoutReference slideLayoutReference) {
    this.slideLayoutReference = slideLayoutReference;
    return this;
  }

  @Override
  public CreateSlideRequest set(String fieldName, Object value) {
    return (CreateSlideRequest) super.set(fieldName, value);
  }

  @Override
  public CreateSlideRequest clone() {
    return (CreateSlideRequest) super.clone();
  }

}
