/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Creates a video. NOTE: Creating a video from Google Drive requires that the requesting app have
 * at least one of the drive, drive.readonly, or drive.file OAuth scopes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateVideoRequest extends com.google.api.client.json.GenericJson {

  /**
   * The element properties for the video. The PageElementProperties.size property is optional. If
   * you don't specify a size, a default size is chosen by the server. The
   * PageElementProperties.transform property is optional. The transform must not have shear
   * components. If you don't specify a transform, the video will be placed at the top left corner
   * of the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageElementProperties elementProperties;

  /**
   * The video source's unique identifier for this video. e.g. For YouTube video
   * https://www.youtube.com/watch?v=7U3axjORYZ0, the ID is 7U3axjORYZ0. For a Google Drive video
   * https://drive.google.com/file/d/1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q the ID is
   * 1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q. To access a Google Drive video file, you might need to add a
   * resource key to the HTTP header for a subset of old files. For more information, see [Access
   * link-shared files using resource keys](https://developers.google.com/drive/api/v3/resource-
   * keys).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The video source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * The element properties for the video. The PageElementProperties.size property is optional. If
   * you don't specify a size, a default size is chosen by the server. The
   * PageElementProperties.transform property is optional. The transform must not have shear
   * components. If you don't specify a transform, the video will be placed at the top left corner
   * of the page.
   * @return value or {@code null} for none
   */
  public PageElementProperties getElementProperties() {
    return elementProperties;
  }

  /**
   * The element properties for the video. The PageElementProperties.size property is optional. If
   * you don't specify a size, a default size is chosen by the server. The
   * PageElementProperties.transform property is optional. The transform must not have shear
   * components. If you don't specify a transform, the video will be placed at the top left corner
   * of the page.
   * @param elementProperties elementProperties or {@code null} for none
   */
  public CreateVideoRequest setElementProperties(PageElementProperties elementProperties) {
    this.elementProperties = elementProperties;
    return this;
  }

  /**
   * The video source's unique identifier for this video. e.g. For YouTube video
   * https://www.youtube.com/watch?v=7U3axjORYZ0, the ID is 7U3axjORYZ0. For a Google Drive video
   * https://drive.google.com/file/d/1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q the ID is
   * 1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q. To access a Google Drive video file, you might need to add a
   * resource key to the HTTP header for a subset of old files. For more information, see [Access
   * link-shared files using resource keys](https://developers.google.com/drive/api/v3/resource-
   * keys).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The video source's unique identifier for this video. e.g. For YouTube video
   * https://www.youtube.com/watch?v=7U3axjORYZ0, the ID is 7U3axjORYZ0. For a Google Drive video
   * https://drive.google.com/file/d/1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q the ID is
   * 1xCgQLFTJi5_Xl8DgW_lcUYq5e-q6Hi5Q. To access a Google Drive video file, you might need to add a
   * resource key to the HTTP header for a subset of old files. For more information, see [Access
   * link-shared files using resource keys](https://developers.google.com/drive/api/v3/resource-
   * keys).
   * @param id id or {@code null} for none
   */
  public CreateVideoRequest setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * A user-supplied object ID. If you specify an ID, it must be unique among all pages and page
   * elements in the presentation. The ID must start with an alphanumeric character or an underscore
   * (matches regex `[a-zA-Z0-9_]`); remaining characters may include those as well as a hyphen or
   * colon (matches regex `[a-zA-Z0-9_-:]`). The length of the ID must not be less than 5 or greater
   * than 50. If you don't specify an ID, a unique one is generated.
   * @param objectId objectId or {@code null} for none
   */
  public CreateVideoRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The video source.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The video source.
   * @param source source or {@code null} for none
   */
  public CreateVideoRequest setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  @Override
  public CreateVideoRequest set(String fieldName, Object value) {
    return (CreateVideoRequest) super.set(fieldName, value);
  }

  @Override
  public CreateVideoRequest clone() {
    return (CreateVideoRequest) super.clone();
  }

}
