/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The crop properties of an object enclosed in a container. For example, an Image. The crop
 * properties is represented by the offsets of four edges which define a crop rectangle. The offsets
 * are measured in percentage from the corresponding edges of the object's original bounding
 * rectangle towards inside, relative to the object's original dimensions. - If the offset is in the
 * interval (0, 1), the corresponding edge of crop rectangle is positioned inside of the object's
 * original bounding rectangle. - If the offset is negative or greater than 1, the corresponding
 * edge of crop rectangle is positioned outside of the object's original bounding rectangle. - If
 * the left edge of the crop rectangle is on the right side of its right edge, the object will be
 * flipped horizontally. - If the top edge of the crop rectangle is below its bottom edge, the
 * object will be flipped vertically. - If all offsets and rotation angle is 0, the object is not
 * cropped. After cropping, the content in the crop rectangle will be stretched to fit its
 * container.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CropProperties extends com.google.api.client.json.GenericJson {

  /**
   * The rotation angle of the crop window around its center, in radians. Rotation angle is applied
   * after the offset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float angle;

  /**
   * The offset specifies the bottom edge of the crop rectangle that is located above the original
   * bounding rectangle bottom edge, relative to the object's original height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float bottomOffset;

  /**
   * The offset specifies the left edge of the crop rectangle that is located to the right of the
   * original bounding rectangle left edge, relative to the object's original width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float leftOffset;

  /**
   * The offset specifies the right edge of the crop rectangle that is located to the left of the
   * original bounding rectangle right edge, relative to the object's original width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float rightOffset;

  /**
   * The offset specifies the top edge of the crop rectangle that is located below the original
   * bounding rectangle top edge, relative to the object's original height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float topOffset;

  /**
   * The rotation angle of the crop window around its center, in radians. Rotation angle is applied
   * after the offset.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAngle() {
    return angle;
  }

  /**
   * The rotation angle of the crop window around its center, in radians. Rotation angle is applied
   * after the offset.
   * @param angle angle or {@code null} for none
   */
  public CropProperties setAngle(java.lang.Float angle) {
    this.angle = angle;
    return this;
  }

  /**
   * The offset specifies the bottom edge of the crop rectangle that is located above the original
   * bounding rectangle bottom edge, relative to the object's original height.
   * @return value or {@code null} for none
   */
  public java.lang.Float getBottomOffset() {
    return bottomOffset;
  }

  /**
   * The offset specifies the bottom edge of the crop rectangle that is located above the original
   * bounding rectangle bottom edge, relative to the object's original height.
   * @param bottomOffset bottomOffset or {@code null} for none
   */
  public CropProperties setBottomOffset(java.lang.Float bottomOffset) {
    this.bottomOffset = bottomOffset;
    return this;
  }

  /**
   * The offset specifies the left edge of the crop rectangle that is located to the right of the
   * original bounding rectangle left edge, relative to the object's original width.
   * @return value or {@code null} for none
   */
  public java.lang.Float getLeftOffset() {
    return leftOffset;
  }

  /**
   * The offset specifies the left edge of the crop rectangle that is located to the right of the
   * original bounding rectangle left edge, relative to the object's original width.
   * @param leftOffset leftOffset or {@code null} for none
   */
  public CropProperties setLeftOffset(java.lang.Float leftOffset) {
    this.leftOffset = leftOffset;
    return this;
  }

  /**
   * The offset specifies the right edge of the crop rectangle that is located to the left of the
   * original bounding rectangle right edge, relative to the object's original width.
   * @return value or {@code null} for none
   */
  public java.lang.Float getRightOffset() {
    return rightOffset;
  }

  /**
   * The offset specifies the right edge of the crop rectangle that is located to the left of the
   * original bounding rectangle right edge, relative to the object's original width.
   * @param rightOffset rightOffset or {@code null} for none
   */
  public CropProperties setRightOffset(java.lang.Float rightOffset) {
    this.rightOffset = rightOffset;
    return this;
  }

  /**
   * The offset specifies the top edge of the crop rectangle that is located below the original
   * bounding rectangle top edge, relative to the object's original height.
   * @return value or {@code null} for none
   */
  public java.lang.Float getTopOffset() {
    return topOffset;
  }

  /**
   * The offset specifies the top edge of the crop rectangle that is located below the original
   * bounding rectangle top edge, relative to the object's original height.
   * @param topOffset topOffset or {@code null} for none
   */
  public CropProperties setTopOffset(java.lang.Float topOffset) {
    this.topOffset = topOffset;
    return this;
  }

  @Override
  public CropProperties set(String fieldName, Object value) {
    return (CropProperties) super.set(fieldName, value);
  }

  @Override
  public CropProperties clone() {
    return (CropProperties) super.clone();
  }

}
