/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Deletes a row from a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteTableRowRequest extends com.google.api.client.json.GenericJson {

  /**
   * The reference table cell location from which a row will be deleted. The row this cell spans
   * will be deleted. If this is a merged cell, multiple rows will be deleted. If no rows remain in
   * the table after this deletion, the whole table is deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation cellLocation;

  /**
   * The table to delete rows from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableObjectId;

  /**
   * The reference table cell location from which a row will be deleted. The row this cell spans
   * will be deleted. If this is a merged cell, multiple rows will be deleted. If no rows remain in
   * the table after this deletion, the whole table is deleted.
   * @return value or {@code null} for none
   */
  public TableCellLocation getCellLocation() {
    return cellLocation;
  }

  /**
   * The reference table cell location from which a row will be deleted. The row this cell spans
   * will be deleted. If this is a merged cell, multiple rows will be deleted. If no rows remain in
   * the table after this deletion, the whole table is deleted.
   * @param cellLocation cellLocation or {@code null} for none
   */
  public DeleteTableRowRequest setCellLocation(TableCellLocation cellLocation) {
    this.cellLocation = cellLocation;
    return this;
  }

  /**
   * The table to delete rows from.
   * @return value or {@code null} for none
   */
  public java.lang.String getTableObjectId() {
    return tableObjectId;
  }

  /**
   * The table to delete rows from.
   * @param tableObjectId tableObjectId or {@code null} for none
   */
  public DeleteTableRowRequest setTableObjectId(java.lang.String tableObjectId) {
    this.tableObjectId = tableObjectId;
    return this;
  }

  @Override
  public DeleteTableRowRequest set(String fieldName, Object value) {
    return (DeleteTableRowRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteTableRowRequest clone() {
    return (DeleteTableRowRequest) super.clone();
  }

}
