/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A magnitude in a single direction in the specified units.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Dimension extends com.google.api.client.json.GenericJson {

  /**
   * The magnitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double magnitude;

  /**
   * The units for magnitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unit;

  /**
   * The magnitude.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMagnitude() {
    return magnitude;
  }

  /**
   * The magnitude.
   * @param magnitude magnitude or {@code null} for none
   */
  public Dimension setMagnitude(java.lang.Double magnitude) {
    this.magnitude = magnitude;
    return this;
  }

  /**
   * The units for magnitude.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnit() {
    return unit;
  }

  /**
   * The units for magnitude.
   * @param unit unit or {@code null} for none
   */
  public Dimension setUnit(java.lang.String unit) {
    this.unit = unit;
    return this;
  }

  @Override
  public Dimension set(String fieldName, Object value) {
    return (Dimension) super.set(fieldName, value);
  }

  @Override
  public Dimension clone() {
    return (Dimension) super.clone();
  }

}
