/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A PageElement kind representing a non-connector line, straight connector, curved connector, or
 * bent connector.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Line extends com.google.api.client.json.GenericJson {

  /**
   * The category of the line. It matches the `category` specified in CreateLineRequest, and can be
   * updated with UpdateLineCategoryRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineCategory;

  /**
   * The properties of the line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LineProperties lineProperties;

  /**
   * The type of the line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineType;

  /**
   * The category of the line. It matches the `category` specified in CreateLineRequest, and can be
   * updated with UpdateLineCategoryRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineCategory() {
    return lineCategory;
  }

  /**
   * The category of the line. It matches the `category` specified in CreateLineRequest, and can be
   * updated with UpdateLineCategoryRequest.
   * @param lineCategory lineCategory or {@code null} for none
   */
  public Line setLineCategory(java.lang.String lineCategory) {
    this.lineCategory = lineCategory;
    return this;
  }

  /**
   * The properties of the line.
   * @return value or {@code null} for none
   */
  public LineProperties getLineProperties() {
    return lineProperties;
  }

  /**
   * The properties of the line.
   * @param lineProperties lineProperties or {@code null} for none
   */
  public Line setLineProperties(LineProperties lineProperties) {
    this.lineProperties = lineProperties;
    return this;
  }

  /**
   * The type of the line.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineType() {
    return lineType;
  }

  /**
   * The type of the line.
   * @param lineType lineType or {@code null} for none
   */
  public Line setLineType(java.lang.String lineType) {
    this.lineType = lineType;
    return this;
  }

  @Override
  public Line set(String fieldName, Object value) {
    return (Line) super.set(fieldName, value);
  }

  @Override
  public Line clone() {
    return (Line) super.clone();
  }

}
