/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The properties for one end of a Line connection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LineConnection extends com.google.api.client.json.GenericJson {

  /**
   * The object ID of the connected page element. Some page elements, such as groups, tables, and
   * lines do not have connection sites and therefore cannot be connected to a connector line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectedObjectId;

  /**
   * The index of the connection site on the connected page element. In most cases, it corresponds
   * to the predefined connection site index from the ECMA-376 standard. More information on those
   * connection sites can be found in both the description of the "cxn" attribute in section
   * 20.1.9.9 and "Annex H. Example Predefined DrawingML Shape and Text Geometries" of "Office Open
   * XML File Formats - Fundamentals and Markup Language Reference", part 1 of [ECMA-376 5th
   * edition](https://ecma-international.org/publications-and-standards/standards/ecma-376/). The
   * position of each connection site can also be viewed from Slides editor.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer connectionSiteIndex;

  /**
   * The object ID of the connected page element. Some page elements, such as groups, tables, and
   * lines do not have connection sites and therefore cannot be connected to a connector line.
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectedObjectId() {
    return connectedObjectId;
  }

  /**
   * The object ID of the connected page element. Some page elements, such as groups, tables, and
   * lines do not have connection sites and therefore cannot be connected to a connector line.
   * @param connectedObjectId connectedObjectId or {@code null} for none
   */
  public LineConnection setConnectedObjectId(java.lang.String connectedObjectId) {
    this.connectedObjectId = connectedObjectId;
    return this;
  }

  /**
   * The index of the connection site on the connected page element. In most cases, it corresponds
   * to the predefined connection site index from the ECMA-376 standard. More information on those
   * connection sites can be found in both the description of the "cxn" attribute in section
   * 20.1.9.9 and "Annex H. Example Predefined DrawingML Shape and Text Geometries" of "Office Open
   * XML File Formats - Fundamentals and Markup Language Reference", part 1 of [ECMA-376 5th
   * edition](https://ecma-international.org/publications-and-standards/standards/ecma-376/). The
   * position of each connection site can also be viewed from Slides editor.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getConnectionSiteIndex() {
    return connectionSiteIndex;
  }

  /**
   * The index of the connection site on the connected page element. In most cases, it corresponds
   * to the predefined connection site index from the ECMA-376 standard. More information on those
   * connection sites can be found in both the description of the "cxn" attribute in section
   * 20.1.9.9 and "Annex H. Example Predefined DrawingML Shape and Text Geometries" of "Office Open
   * XML File Formats - Fundamentals and Markup Language Reference", part 1 of [ECMA-376 5th
   * edition](https://ecma-international.org/publications-and-standards/standards/ecma-376/). The
   * position of each connection site can also be viewed from Slides editor.
   * @param connectionSiteIndex connectionSiteIndex or {@code null} for none
   */
  public LineConnection setConnectionSiteIndex(java.lang.Integer connectionSiteIndex) {
    this.connectionSiteIndex = connectionSiteIndex;
    return this;
  }

  @Override
  public LineConnection set(String fieldName, Object value) {
    return (LineConnection) super.set(fieldName, value);
  }

  @Override
  public LineConnection clone() {
    return (LineConnection) super.clone();
  }

}
