/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Merges cells in a Table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MergeTableCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The object ID of the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The table range specifying which cells of the table to merge. Any text in the cells being
   * merged will be concatenated and stored in the upper-left ("head") cell of the range. If the
   * range is non-rectangular (which can occur in some cases where the range covers cells that are
   * already merged), a 400 bad request error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRange tableRange;

  /**
   * The object ID of the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the table.
   * @param objectId objectId or {@code null} for none
   */
  public MergeTableCellsRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The table range specifying which cells of the table to merge. Any text in the cells being
   * merged will be concatenated and stored in the upper-left ("head") cell of the range. If the
   * range is non-rectangular (which can occur in some cases where the range covers cells that are
   * already merged), a 400 bad request error is returned.
   * @return value or {@code null} for none
   */
  public TableRange getTableRange() {
    return tableRange;
  }

  /**
   * The table range specifying which cells of the table to merge. Any text in the cells being
   * merged will be concatenated and stored in the upper-left ("head") cell of the range. If the
   * range is non-rectangular (which can occur in some cases where the range covers cells that are
   * already merged), a 400 bad request error is returned.
   * @param tableRange tableRange or {@code null} for none
   */
  public MergeTableCellsRequest setTableRange(TableRange tableRange) {
    this.tableRange = tableRange;
    return this;
  }

  @Override
  public MergeTableCellsRequest set(String fieldName, Object value) {
    return (MergeTableCellsRequest) super.set(fieldName, value);
  }

  @Override
  public MergeTableCellsRequest clone() {
    return (MergeTableCellsRequest) super.clone();
  }

}
