/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A color that can either be fully opaque or fully transparent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OptionalColor extends com.google.api.client.json.GenericJson {

  /**
   * If set, this will be used as an opaque color. If unset, this represents a transparent color.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OpaqueColor opaqueColor;

  /**
   * If set, this will be used as an opaque color. If unset, this represents a transparent color.
   * @return value or {@code null} for none
   */
  public OpaqueColor getOpaqueColor() {
    return opaqueColor;
  }

  /**
   * If set, this will be used as an opaque color. If unset, this represents a transparent color.
   * @param opaqueColor opaqueColor or {@code null} for none
   */
  public OptionalColor setOpaqueColor(OpaqueColor opaqueColor) {
    this.opaqueColor = opaqueColor;
    return this;
  }

  @Override
  public OptionalColor set(String fieldName, Object value) {
    return (OptionalColor) super.set(fieldName, value);
  }

  @Override
  public OptionalColor clone() {
    return (OptionalColor) super.clone();
  }

}
