/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Specifies a contiguous range of an indexed collection, such as characters in text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Range extends com.google.api.client.json.GenericJson {

  /**
   * The optional zero-based index of the end of the collection. Required for `FIXED_RANGE` ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endIndex;

  /**
   * The optional zero-based index of the beginning of the collection. Required for `FIXED_RANGE`
   * and `FROM_START_INDEX` ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The type of range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The optional zero-based index of the end of the collection. Required for `FIXED_RANGE` ranges.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndIndex() {
    return endIndex;
  }

  /**
   * The optional zero-based index of the end of the collection. Required for `FIXED_RANGE` ranges.
   * @param endIndex endIndex or {@code null} for none
   */
  public Range setEndIndex(java.lang.Integer endIndex) {
    this.endIndex = endIndex;
    return this;
  }

  /**
   * The optional zero-based index of the beginning of the collection. Required for `FIXED_RANGE`
   * and `FROM_START_INDEX` ranges.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The optional zero-based index of the beginning of the collection. Required for `FIXED_RANGE`
   * and `FROM_START_INDEX` ranges.
   * @param startIndex startIndex or {@code null} for none
   */
  public Range setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The type of range.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of range.
   * @param type type or {@code null} for none
   */
  public Range setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Range set(String fieldName, Object value) {
    return (Range) super.set(fieldName, value);
  }

  @Override
  public Range clone() {
    return (Range) super.clone();
  }

}
