/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A recolor effect applied on an image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Recolor extends com.google.api.client.json.GenericJson {

  /**
   * The name of the recolor effect. The name is determined from the `recolor_stops` by matching the
   * gradient against the colors in the page's current color scheme. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The recolor effect is represented by a gradient, which is a list of color stops. The colors in
   * the gradient will replace the corresponding colors at the same position in the color palette
   * and apply to the image. This property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ColorStop> recolorStops;

  static {
    // hack to force ProGuard to consider ColorStop used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ColorStop.class);
  }

  /**
   * The name of the recolor effect. The name is determined from the `recolor_stops` by matching the
   * gradient against the colors in the page's current color scheme. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the recolor effect. The name is determined from the `recolor_stops` by matching the
   * gradient against the colors in the page's current color scheme. This property is read-only.
   * @param name name or {@code null} for none
   */
  public Recolor setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The recolor effect is represented by a gradient, which is a list of color stops. The colors in
   * the gradient will replace the corresponding colors at the same position in the color palette
   * and apply to the image. This property is read-only.
   * @return value or {@code null} for none
   */
  public java.util.List<ColorStop> getRecolorStops() {
    return recolorStops;
  }

  /**
   * The recolor effect is represented by a gradient, which is a list of color stops. The colors in
   * the gradient will replace the corresponding colors at the same position in the color palette
   * and apply to the image. This property is read-only.
   * @param recolorStops recolorStops or {@code null} for none
   */
  public Recolor setRecolorStops(java.util.List<ColorStop> recolorStops) {
    this.recolorStops = recolorStops;
    return this;
  }

  @Override
  public Recolor set(String fieldName, Object value) {
    return (Recolor) super.set(fieldName, value);
  }

  @Override
  public Recolor clone() {
    return (Recolor) super.clone();
  }

}
