/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Replaces all shapes that match the given criteria with the provided image. The images replacing
 * the shapes are rectangular after being inserted into the presentation and do not take on the
 * forms of the shapes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplaceAllShapesWithImageRequest extends com.google.api.client.json.GenericJson {

  /**
   * If set, this request will replace all of the shapes that contain the given text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubstringMatchCriteria containsText;

  /**
   * The image replace method. If you specify both a `replace_method` and an `image_replace_method`,
   * the `image_replace_method` takes precedence. If you do not specify a value for
   * `image_replace_method`, but specify a value for `replace_method`, then the specified
   * `replace_method` value is used. If you do not specify either, then CENTER_INSIDE is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageReplaceMethod;

  /**
   * The image URL. The image is fetched once at insertion time and a copy is stored for display
   * inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels,
   * and must be in one of PNG, JPEG, or GIF format. The provided URL can be at most 2 kB in length.
   * The URL itself is saved with the image, and exposed via the Image.source_url field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageUrl;

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes page or a notes master, or if a page with
   * that object ID doesn't exist in the presentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pageObjectIds;

  /**
   * The replace method. *Deprecated*: use `image_replace_method` instead. If you specify both a
   * `replace_method` and an `image_replace_method`, the `image_replace_method` takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replaceMethod;

  /**
   * If set, this request will replace all of the shapes that contain the given text.
   * @return value or {@code null} for none
   */
  public SubstringMatchCriteria getContainsText() {
    return containsText;
  }

  /**
   * If set, this request will replace all of the shapes that contain the given text.
   * @param containsText containsText or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest setContainsText(SubstringMatchCriteria containsText) {
    this.containsText = containsText;
    return this;
  }

  /**
   * The image replace method. If you specify both a `replace_method` and an `image_replace_method`,
   * the `image_replace_method` takes precedence. If you do not specify a value for
   * `image_replace_method`, but specify a value for `replace_method`, then the specified
   * `replace_method` value is used. If you do not specify either, then CENTER_INSIDE is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageReplaceMethod() {
    return imageReplaceMethod;
  }

  /**
   * The image replace method. If you specify both a `replace_method` and an `image_replace_method`,
   * the `image_replace_method` takes precedence. If you do not specify a value for
   * `image_replace_method`, but specify a value for `replace_method`, then the specified
   * `replace_method` value is used. If you do not specify either, then CENTER_INSIDE is used.
   * @param imageReplaceMethod imageReplaceMethod or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest setImageReplaceMethod(java.lang.String imageReplaceMethod) {
    this.imageReplaceMethod = imageReplaceMethod;
    return this;
  }

  /**
   * The image URL. The image is fetched once at insertion time and a copy is stored for display
   * inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels,
   * and must be in one of PNG, JPEG, or GIF format. The provided URL can be at most 2 kB in length.
   * The URL itself is saved with the image, and exposed via the Image.source_url field.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageUrl() {
    return imageUrl;
  }

  /**
   * The image URL. The image is fetched once at insertion time and a copy is stored for display
   * inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels,
   * and must be in one of PNG, JPEG, or GIF format. The provided URL can be at most 2 kB in length.
   * The URL itself is saved with the image, and exposed via the Image.source_url field.
   * @param imageUrl imageUrl or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest setImageUrl(java.lang.String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes page or a notes master, or if a page with
   * that object ID doesn't exist in the presentation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPageObjectIds() {
    return pageObjectIds;
  }

  /**
   * If non-empty, limits the matches to page elements only on the given pages. Returns a 400 bad
   * request error if given the page object ID of a notes page or a notes master, or if a page with
   * that object ID doesn't exist in the presentation.
   * @param pageObjectIds pageObjectIds or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest setPageObjectIds(java.util.List<java.lang.String> pageObjectIds) {
    this.pageObjectIds = pageObjectIds;
    return this;
  }

  /**
   * The replace method. *Deprecated*: use `image_replace_method` instead. If you specify both a
   * `replace_method` and an `image_replace_method`, the `image_replace_method` takes precedence.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplaceMethod() {
    return replaceMethod;
  }

  /**
   * The replace method. *Deprecated*: use `image_replace_method` instead. If you specify both a
   * `replace_method` and an `image_replace_method`, the `image_replace_method` takes precedence.
   * @param replaceMethod replaceMethod or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest setReplaceMethod(java.lang.String replaceMethod) {
    this.replaceMethod = replaceMethod;
    return this;
  }

  @Override
  public ReplaceAllShapesWithImageRequest set(String fieldName, Object value) {
    return (ReplaceAllShapesWithImageRequest) super.set(fieldName, value);
  }

  @Override
  public ReplaceAllShapesWithImageRequest clone() {
    return (ReplaceAllShapesWithImageRequest) super.clone();
  }

}
