/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * A single kind of update to apply to a presentation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Request extends com.google.api.client.json.GenericJson {

  /**
   * Creates an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateImageRequest createImage;

  /**
   * Creates a line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateLineRequest createLine;

  /**
   * Creates bullets for paragraphs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateParagraphBulletsRequest createParagraphBullets;

  /**
   * Creates a new shape.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateShapeRequest createShape;

  /**
   * Creates an embedded Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateSheetsChartRequest createSheetsChart;

  /**
   * Creates a new slide.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateSlideRequest createSlide;

  /**
   * Creates a new table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateTableRequest createTable;

  /**
   * Creates a video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateVideoRequest createVideo;

  /**
   * Deletes a page or page element from the presentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteObjectRequest deleteObject;

  /**
   * Deletes bullets from paragraphs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteParagraphBulletsRequest deleteParagraphBullets;

  /**
   * Deletes a column from a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteTableColumnRequest deleteTableColumn;

  /**
   * Deletes a row from a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteTableRowRequest deleteTableRow;

  /**
   * Deletes text from a shape or a table cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteTextRequest deleteText;

  /**
   * Duplicates a slide or page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DuplicateObjectRequest duplicateObject;

  /**
   * Groups objects, such as page elements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupObjectsRequest groupObjects;

  /**
   * Inserts columns into a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertTableColumnsRequest insertTableColumns;

  /**
   * Inserts rows into a table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertTableRowsRequest insertTableRows;

  /**
   * Inserts text into a shape or table cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertTextRequest insertText;

  /**
   * Merges cells in a Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MergeTableCellsRequest mergeTableCells;

  /**
   * Refreshes a Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RefreshSheetsChartRequest refreshSheetsChart;

  /**
   * Replaces all shapes matching some criteria with an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllShapesWithImageRequest replaceAllShapesWithImage;

  /**
   * Replaces all shapes matching some criteria with a Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllShapesWithSheetsChartRequest replaceAllShapesWithSheetsChart;

  /**
   * Replaces all instances of specified text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllTextRequest replaceAllText;

  /**
   * Replaces an existing image with a new image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceImageRequest replaceImage;

  /**
   * Reroutes a line such that it's connected at the two closest connection sites on the connected
   * page elements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RerouteLineRequest rerouteLine;

  /**
   * Ungroups objects, such as groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UngroupObjectsRequest ungroupObjects;

  /**
   * Unmerges cells in a Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UnmergeTableCellsRequest unmergeTableCells;

  /**
   * Updates the properties of an Image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateImagePropertiesRequest updateImageProperties;

  /**
   * Updates the category of a line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateLineCategoryRequest updateLineCategory;

  /**
   * Updates the properties of a Line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateLinePropertiesRequest updateLineProperties;

  /**
   * Updates the alt text title and/or description of a page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdatePageElementAltTextRequest updatePageElementAltText;

  /**
   * Updates the transform of a page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdatePageElementTransformRequest updatePageElementTransform;

  /**
   * Updates the Z-order of page elements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdatePageElementsZOrderRequest updatePageElementsZOrder;

  /**
   * Updates the properties of a Page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdatePagePropertiesRequest updatePageProperties;

  /**
   * Updates the styling of paragraphs within a Shape or Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateParagraphStyleRequest updateParagraphStyle;

  /**
   * Updates the properties of a Shape.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateShapePropertiesRequest updateShapeProperties;

  /**
   * Updates the properties of a Slide
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateSlidePropertiesRequest updateSlideProperties;

  /**
   * Updates the position of a set of slides in the presentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateSlidesPositionRequest updateSlidesPosition;

  /**
   * Updates the properties of the table borders in a Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateTableBorderPropertiesRequest updateTableBorderProperties;

  /**
   * Updates the properties of a TableCell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateTableCellPropertiesRequest updateTableCellProperties;

  /**
   * Updates the properties of a Table column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateTableColumnPropertiesRequest updateTableColumnProperties;

  /**
   * Updates the properties of a Table row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateTableRowPropertiesRequest updateTableRowProperties;

  /**
   * Updates the styling of text within a Shape or Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateTextStyleRequest updateTextStyle;

  /**
   * Updates the properties of a Video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateVideoPropertiesRequest updateVideoProperties;

  /**
   * Creates an image.
   * @return value or {@code null} for none
   */
  public CreateImageRequest getCreateImage() {
    return createImage;
  }

  /**
   * Creates an image.
   * @param createImage createImage or {@code null} for none
   */
  public Request setCreateImage(CreateImageRequest createImage) {
    this.createImage = createImage;
    return this;
  }

  /**
   * Creates a line.
   * @return value or {@code null} for none
   */
  public CreateLineRequest getCreateLine() {
    return createLine;
  }

  /**
   * Creates a line.
   * @param createLine createLine or {@code null} for none
   */
  public Request setCreateLine(CreateLineRequest createLine) {
    this.createLine = createLine;
    return this;
  }

  /**
   * Creates bullets for paragraphs.
   * @return value or {@code null} for none
   */
  public CreateParagraphBulletsRequest getCreateParagraphBullets() {
    return createParagraphBullets;
  }

  /**
   * Creates bullets for paragraphs.
   * @param createParagraphBullets createParagraphBullets or {@code null} for none
   */
  public Request setCreateParagraphBullets(CreateParagraphBulletsRequest createParagraphBullets) {
    this.createParagraphBullets = createParagraphBullets;
    return this;
  }

  /**
   * Creates a new shape.
   * @return value or {@code null} for none
   */
  public CreateShapeRequest getCreateShape() {
    return createShape;
  }

  /**
   * Creates a new shape.
   * @param createShape createShape or {@code null} for none
   */
  public Request setCreateShape(CreateShapeRequest createShape) {
    this.createShape = createShape;
    return this;
  }

  /**
   * Creates an embedded Google Sheets chart.
   * @return value or {@code null} for none
   */
  public CreateSheetsChartRequest getCreateSheetsChart() {
    return createSheetsChart;
  }

  /**
   * Creates an embedded Google Sheets chart.
   * @param createSheetsChart createSheetsChart or {@code null} for none
   */
  public Request setCreateSheetsChart(CreateSheetsChartRequest createSheetsChart) {
    this.createSheetsChart = createSheetsChart;
    return this;
  }

  /**
   * Creates a new slide.
   * @return value or {@code null} for none
   */
  public CreateSlideRequest getCreateSlide() {
    return createSlide;
  }

  /**
   * Creates a new slide.
   * @param createSlide createSlide or {@code null} for none
   */
  public Request setCreateSlide(CreateSlideRequest createSlide) {
    this.createSlide = createSlide;
    return this;
  }

  /**
   * Creates a new table.
   * @return value or {@code null} for none
   */
  public CreateTableRequest getCreateTable() {
    return createTable;
  }

  /**
   * Creates a new table.
   * @param createTable createTable or {@code null} for none
   */
  public Request setCreateTable(CreateTableRequest createTable) {
    this.createTable = createTable;
    return this;
  }

  /**
   * Creates a video.
   * @return value or {@code null} for none
   */
  public CreateVideoRequest getCreateVideo() {
    return createVideo;
  }

  /**
   * Creates a video.
   * @param createVideo createVideo or {@code null} for none
   */
  public Request setCreateVideo(CreateVideoRequest createVideo) {
    this.createVideo = createVideo;
    return this;
  }

  /**
   * Deletes a page or page element from the presentation.
   * @return value or {@code null} for none
   */
  public DeleteObjectRequest getDeleteObject() {
    return deleteObject;
  }

  /**
   * Deletes a page or page element from the presentation.
   * @param deleteObject deleteObject or {@code null} for none
   */
  public Request setDeleteObject(DeleteObjectRequest deleteObject) {
    this.deleteObject = deleteObject;
    return this;
  }

  /**
   * Deletes bullets from paragraphs.
   * @return value or {@code null} for none
   */
  public DeleteParagraphBulletsRequest getDeleteParagraphBullets() {
    return deleteParagraphBullets;
  }

  /**
   * Deletes bullets from paragraphs.
   * @param deleteParagraphBullets deleteParagraphBullets or {@code null} for none
   */
  public Request setDeleteParagraphBullets(DeleteParagraphBulletsRequest deleteParagraphBullets) {
    this.deleteParagraphBullets = deleteParagraphBullets;
    return this;
  }

  /**
   * Deletes a column from a table.
   * @return value or {@code null} for none
   */
  public DeleteTableColumnRequest getDeleteTableColumn() {
    return deleteTableColumn;
  }

  /**
   * Deletes a column from a table.
   * @param deleteTableColumn deleteTableColumn or {@code null} for none
   */
  public Request setDeleteTableColumn(DeleteTableColumnRequest deleteTableColumn) {
    this.deleteTableColumn = deleteTableColumn;
    return this;
  }

  /**
   * Deletes a row from a table.
   * @return value or {@code null} for none
   */
  public DeleteTableRowRequest getDeleteTableRow() {
    return deleteTableRow;
  }

  /**
   * Deletes a row from a table.
   * @param deleteTableRow deleteTableRow or {@code null} for none
   */
  public Request setDeleteTableRow(DeleteTableRowRequest deleteTableRow) {
    this.deleteTableRow = deleteTableRow;
    return this;
  }

  /**
   * Deletes text from a shape or a table cell.
   * @return value or {@code null} for none
   */
  public DeleteTextRequest getDeleteText() {
    return deleteText;
  }

  /**
   * Deletes text from a shape or a table cell.
   * @param deleteText deleteText or {@code null} for none
   */
  public Request setDeleteText(DeleteTextRequest deleteText) {
    this.deleteText = deleteText;
    return this;
  }

  /**
   * Duplicates a slide or page element.
   * @return value or {@code null} for none
   */
  public DuplicateObjectRequest getDuplicateObject() {
    return duplicateObject;
  }

  /**
   * Duplicates a slide or page element.
   * @param duplicateObject duplicateObject or {@code null} for none
   */
  public Request setDuplicateObject(DuplicateObjectRequest duplicateObject) {
    this.duplicateObject = duplicateObject;
    return this;
  }

  /**
   * Groups objects, such as page elements.
   * @return value or {@code null} for none
   */
  public GroupObjectsRequest getGroupObjects() {
    return groupObjects;
  }

  /**
   * Groups objects, such as page elements.
   * @param groupObjects groupObjects or {@code null} for none
   */
  public Request setGroupObjects(GroupObjectsRequest groupObjects) {
    this.groupObjects = groupObjects;
    return this;
  }

  /**
   * Inserts columns into a table.
   * @return value or {@code null} for none
   */
  public InsertTableColumnsRequest getInsertTableColumns() {
    return insertTableColumns;
  }

  /**
   * Inserts columns into a table.
   * @param insertTableColumns insertTableColumns or {@code null} for none
   */
  public Request setInsertTableColumns(InsertTableColumnsRequest insertTableColumns) {
    this.insertTableColumns = insertTableColumns;
    return this;
  }

  /**
   * Inserts rows into a table.
   * @return value or {@code null} for none
   */
  public InsertTableRowsRequest getInsertTableRows() {
    return insertTableRows;
  }

  /**
   * Inserts rows into a table.
   * @param insertTableRows insertTableRows or {@code null} for none
   */
  public Request setInsertTableRows(InsertTableRowsRequest insertTableRows) {
    this.insertTableRows = insertTableRows;
    return this;
  }

  /**
   * Inserts text into a shape or table cell.
   * @return value or {@code null} for none
   */
  public InsertTextRequest getInsertText() {
    return insertText;
  }

  /**
   * Inserts text into a shape or table cell.
   * @param insertText insertText or {@code null} for none
   */
  public Request setInsertText(InsertTextRequest insertText) {
    this.insertText = insertText;
    return this;
  }

  /**
   * Merges cells in a Table.
   * @return value or {@code null} for none
   */
  public MergeTableCellsRequest getMergeTableCells() {
    return mergeTableCells;
  }

  /**
   * Merges cells in a Table.
   * @param mergeTableCells mergeTableCells or {@code null} for none
   */
  public Request setMergeTableCells(MergeTableCellsRequest mergeTableCells) {
    this.mergeTableCells = mergeTableCells;
    return this;
  }

  /**
   * Refreshes a Google Sheets chart.
   * @return value or {@code null} for none
   */
  public RefreshSheetsChartRequest getRefreshSheetsChart() {
    return refreshSheetsChart;
  }

  /**
   * Refreshes a Google Sheets chart.
   * @param refreshSheetsChart refreshSheetsChart or {@code null} for none
   */
  public Request setRefreshSheetsChart(RefreshSheetsChartRequest refreshSheetsChart) {
    this.refreshSheetsChart = refreshSheetsChart;
    return this;
  }

  /**
   * Replaces all shapes matching some criteria with an image.
   * @return value or {@code null} for none
   */
  public ReplaceAllShapesWithImageRequest getReplaceAllShapesWithImage() {
    return replaceAllShapesWithImage;
  }

  /**
   * Replaces all shapes matching some criteria with an image.
   * @param replaceAllShapesWithImage replaceAllShapesWithImage or {@code null} for none
   */
  public Request setReplaceAllShapesWithImage(ReplaceAllShapesWithImageRequest replaceAllShapesWithImage) {
    this.replaceAllShapesWithImage = replaceAllShapesWithImage;
    return this;
  }

  /**
   * Replaces all shapes matching some criteria with a Google Sheets chart.
   * @return value or {@code null} for none
   */
  public ReplaceAllShapesWithSheetsChartRequest getReplaceAllShapesWithSheetsChart() {
    return replaceAllShapesWithSheetsChart;
  }

  /**
   * Replaces all shapes matching some criteria with a Google Sheets chart.
   * @param replaceAllShapesWithSheetsChart replaceAllShapesWithSheetsChart or {@code null} for none
   */
  public Request setReplaceAllShapesWithSheetsChart(ReplaceAllShapesWithSheetsChartRequest replaceAllShapesWithSheetsChart) {
    this.replaceAllShapesWithSheetsChart = replaceAllShapesWithSheetsChart;
    return this;
  }

  /**
   * Replaces all instances of specified text.
   * @return value or {@code null} for none
   */
  public ReplaceAllTextRequest getReplaceAllText() {
    return replaceAllText;
  }

  /**
   * Replaces all instances of specified text.
   * @param replaceAllText replaceAllText or {@code null} for none
   */
  public Request setReplaceAllText(ReplaceAllTextRequest replaceAllText) {
    this.replaceAllText = replaceAllText;
    return this;
  }

  /**
   * Replaces an existing image with a new image.
   * @return value or {@code null} for none
   */
  public ReplaceImageRequest getReplaceImage() {
    return replaceImage;
  }

  /**
   * Replaces an existing image with a new image.
   * @param replaceImage replaceImage or {@code null} for none
   */
  public Request setReplaceImage(ReplaceImageRequest replaceImage) {
    this.replaceImage = replaceImage;
    return this;
  }

  /**
   * Reroutes a line such that it's connected at the two closest connection sites on the connected
   * page elements.
   * @return value or {@code null} for none
   */
  public RerouteLineRequest getRerouteLine() {
    return rerouteLine;
  }

  /**
   * Reroutes a line such that it's connected at the two closest connection sites on the connected
   * page elements.
   * @param rerouteLine rerouteLine or {@code null} for none
   */
  public Request setRerouteLine(RerouteLineRequest rerouteLine) {
    this.rerouteLine = rerouteLine;
    return this;
  }

  /**
   * Ungroups objects, such as groups.
   * @return value or {@code null} for none
   */
  public UngroupObjectsRequest getUngroupObjects() {
    return ungroupObjects;
  }

  /**
   * Ungroups objects, such as groups.
   * @param ungroupObjects ungroupObjects or {@code null} for none
   */
  public Request setUngroupObjects(UngroupObjectsRequest ungroupObjects) {
    this.ungroupObjects = ungroupObjects;
    return this;
  }

  /**
   * Unmerges cells in a Table.
   * @return value or {@code null} for none
   */
  public UnmergeTableCellsRequest getUnmergeTableCells() {
    return unmergeTableCells;
  }

  /**
   * Unmerges cells in a Table.
   * @param unmergeTableCells unmergeTableCells or {@code null} for none
   */
  public Request setUnmergeTableCells(UnmergeTableCellsRequest unmergeTableCells) {
    this.unmergeTableCells = unmergeTableCells;
    return this;
  }

  /**
   * Updates the properties of an Image.
   * @return value or {@code null} for none
   */
  public UpdateImagePropertiesRequest getUpdateImageProperties() {
    return updateImageProperties;
  }

  /**
   * Updates the properties of an Image.
   * @param updateImageProperties updateImageProperties or {@code null} for none
   */
  public Request setUpdateImageProperties(UpdateImagePropertiesRequest updateImageProperties) {
    this.updateImageProperties = updateImageProperties;
    return this;
  }

  /**
   * Updates the category of a line.
   * @return value or {@code null} for none
   */
  public UpdateLineCategoryRequest getUpdateLineCategory() {
    return updateLineCategory;
  }

  /**
   * Updates the category of a line.
   * @param updateLineCategory updateLineCategory or {@code null} for none
   */
  public Request setUpdateLineCategory(UpdateLineCategoryRequest updateLineCategory) {
    this.updateLineCategory = updateLineCategory;
    return this;
  }

  /**
   * Updates the properties of a Line.
   * @return value or {@code null} for none
   */
  public UpdateLinePropertiesRequest getUpdateLineProperties() {
    return updateLineProperties;
  }

  /**
   * Updates the properties of a Line.
   * @param updateLineProperties updateLineProperties or {@code null} for none
   */
  public Request setUpdateLineProperties(UpdateLinePropertiesRequest updateLineProperties) {
    this.updateLineProperties = updateLineProperties;
    return this;
  }

  /**
   * Updates the alt text title and/or description of a page element.
   * @return value or {@code null} for none
   */
  public UpdatePageElementAltTextRequest getUpdatePageElementAltText() {
    return updatePageElementAltText;
  }

  /**
   * Updates the alt text title and/or description of a page element.
   * @param updatePageElementAltText updatePageElementAltText or {@code null} for none
   */
  public Request setUpdatePageElementAltText(UpdatePageElementAltTextRequest updatePageElementAltText) {
    this.updatePageElementAltText = updatePageElementAltText;
    return this;
  }

  /**
   * Updates the transform of a page element.
   * @return value or {@code null} for none
   */
  public UpdatePageElementTransformRequest getUpdatePageElementTransform() {
    return updatePageElementTransform;
  }

  /**
   * Updates the transform of a page element.
   * @param updatePageElementTransform updatePageElementTransform or {@code null} for none
   */
  public Request setUpdatePageElementTransform(UpdatePageElementTransformRequest updatePageElementTransform) {
    this.updatePageElementTransform = updatePageElementTransform;
    return this;
  }

  /**
   * Updates the Z-order of page elements.
   * @return value or {@code null} for none
   */
  public UpdatePageElementsZOrderRequest getUpdatePageElementsZOrder() {
    return updatePageElementsZOrder;
  }

  /**
   * Updates the Z-order of page elements.
   * @param updatePageElementsZOrder updatePageElementsZOrder or {@code null} for none
   */
  public Request setUpdatePageElementsZOrder(UpdatePageElementsZOrderRequest updatePageElementsZOrder) {
    this.updatePageElementsZOrder = updatePageElementsZOrder;
    return this;
  }

  /**
   * Updates the properties of a Page.
   * @return value or {@code null} for none
   */
  public UpdatePagePropertiesRequest getUpdatePageProperties() {
    return updatePageProperties;
  }

  /**
   * Updates the properties of a Page.
   * @param updatePageProperties updatePageProperties or {@code null} for none
   */
  public Request setUpdatePageProperties(UpdatePagePropertiesRequest updatePageProperties) {
    this.updatePageProperties = updatePageProperties;
    return this;
  }

  /**
   * Updates the styling of paragraphs within a Shape or Table.
   * @return value or {@code null} for none
   */
  public UpdateParagraphStyleRequest getUpdateParagraphStyle() {
    return updateParagraphStyle;
  }

  /**
   * Updates the styling of paragraphs within a Shape or Table.
   * @param updateParagraphStyle updateParagraphStyle or {@code null} for none
   */
  public Request setUpdateParagraphStyle(UpdateParagraphStyleRequest updateParagraphStyle) {
    this.updateParagraphStyle = updateParagraphStyle;
    return this;
  }

  /**
   * Updates the properties of a Shape.
   * @return value or {@code null} for none
   */
  public UpdateShapePropertiesRequest getUpdateShapeProperties() {
    return updateShapeProperties;
  }

  /**
   * Updates the properties of a Shape.
   * @param updateShapeProperties updateShapeProperties or {@code null} for none
   */
  public Request setUpdateShapeProperties(UpdateShapePropertiesRequest updateShapeProperties) {
    this.updateShapeProperties = updateShapeProperties;
    return this;
  }

  /**
   * Updates the properties of a Slide
   * @return value or {@code null} for none
   */
  public UpdateSlidePropertiesRequest getUpdateSlideProperties() {
    return updateSlideProperties;
  }

  /**
   * Updates the properties of a Slide
   * @param updateSlideProperties updateSlideProperties or {@code null} for none
   */
  public Request setUpdateSlideProperties(UpdateSlidePropertiesRequest updateSlideProperties) {
    this.updateSlideProperties = updateSlideProperties;
    return this;
  }

  /**
   * Updates the position of a set of slides in the presentation.
   * @return value or {@code null} for none
   */
  public UpdateSlidesPositionRequest getUpdateSlidesPosition() {
    return updateSlidesPosition;
  }

  /**
   * Updates the position of a set of slides in the presentation.
   * @param updateSlidesPosition updateSlidesPosition or {@code null} for none
   */
  public Request setUpdateSlidesPosition(UpdateSlidesPositionRequest updateSlidesPosition) {
    this.updateSlidesPosition = updateSlidesPosition;
    return this;
  }

  /**
   * Updates the properties of the table borders in a Table.
   * @return value or {@code null} for none
   */
  public UpdateTableBorderPropertiesRequest getUpdateTableBorderProperties() {
    return updateTableBorderProperties;
  }

  /**
   * Updates the properties of the table borders in a Table.
   * @param updateTableBorderProperties updateTableBorderProperties or {@code null} for none
   */
  public Request setUpdateTableBorderProperties(UpdateTableBorderPropertiesRequest updateTableBorderProperties) {
    this.updateTableBorderProperties = updateTableBorderProperties;
    return this;
  }

  /**
   * Updates the properties of a TableCell.
   * @return value or {@code null} for none
   */
  public UpdateTableCellPropertiesRequest getUpdateTableCellProperties() {
    return updateTableCellProperties;
  }

  /**
   * Updates the properties of a TableCell.
   * @param updateTableCellProperties updateTableCellProperties or {@code null} for none
   */
  public Request setUpdateTableCellProperties(UpdateTableCellPropertiesRequest updateTableCellProperties) {
    this.updateTableCellProperties = updateTableCellProperties;
    return this;
  }

  /**
   * Updates the properties of a Table column.
   * @return value or {@code null} for none
   */
  public UpdateTableColumnPropertiesRequest getUpdateTableColumnProperties() {
    return updateTableColumnProperties;
  }

  /**
   * Updates the properties of a Table column.
   * @param updateTableColumnProperties updateTableColumnProperties or {@code null} for none
   */
  public Request setUpdateTableColumnProperties(UpdateTableColumnPropertiesRequest updateTableColumnProperties) {
    this.updateTableColumnProperties = updateTableColumnProperties;
    return this;
  }

  /**
   * Updates the properties of a Table row.
   * @return value or {@code null} for none
   */
  public UpdateTableRowPropertiesRequest getUpdateTableRowProperties() {
    return updateTableRowProperties;
  }

  /**
   * Updates the properties of a Table row.
   * @param updateTableRowProperties updateTableRowProperties or {@code null} for none
   */
  public Request setUpdateTableRowProperties(UpdateTableRowPropertiesRequest updateTableRowProperties) {
    this.updateTableRowProperties = updateTableRowProperties;
    return this;
  }

  /**
   * Updates the styling of text within a Shape or Table.
   * @return value or {@code null} for none
   */
  public UpdateTextStyleRequest getUpdateTextStyle() {
    return updateTextStyle;
  }

  /**
   * Updates the styling of text within a Shape or Table.
   * @param updateTextStyle updateTextStyle or {@code null} for none
   */
  public Request setUpdateTextStyle(UpdateTextStyleRequest updateTextStyle) {
    this.updateTextStyle = updateTextStyle;
    return this;
  }

  /**
   * Updates the properties of a Video.
   * @return value or {@code null} for none
   */
  public UpdateVideoPropertiesRequest getUpdateVideoProperties() {
    return updateVideoProperties;
  }

  /**
   * Updates the properties of a Video.
   * @param updateVideoProperties updateVideoProperties or {@code null} for none
   */
  public Request setUpdateVideoProperties(UpdateVideoPropertiesRequest updateVideoProperties) {
    this.updateVideoProperties = updateVideoProperties;
    return this;
  }

  @Override
  public Request set(String fieldName, Object value) {
    return (Request) super.set(fieldName, value);
  }

  @Override
  public Request clone() {
    return (Request) super.clone();
  }

}
