/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The properties of the SpeakerSpotlight.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SpeakerSpotlightProperties extends com.google.api.client.json.GenericJson {

  /**
   * The outline of the Speaker Spotlight. If not set, it has no outline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Outline outline;

  /**
   * The shadow of the Speaker Spotlight. If not set, it has no shadow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Shadow shadow;

  /**
   * The outline of the Speaker Spotlight. If not set, it has no outline.
   * @return value or {@code null} for none
   */
  public Outline getOutline() {
    return outline;
  }

  /**
   * The outline of the Speaker Spotlight. If not set, it has no outline.
   * @param outline outline or {@code null} for none
   */
  public SpeakerSpotlightProperties setOutline(Outline outline) {
    this.outline = outline;
    return this;
  }

  /**
   * The shadow of the Speaker Spotlight. If not set, it has no shadow.
   * @return value or {@code null} for none
   */
  public Shadow getShadow() {
    return shadow;
  }

  /**
   * The shadow of the Speaker Spotlight. If not set, it has no shadow.
   * @param shadow shadow or {@code null} for none
   */
  public SpeakerSpotlightProperties setShadow(Shadow shadow) {
    this.shadow = shadow;
    return this;
  }

  @Override
  public SpeakerSpotlightProperties set(String fieldName, Object value) {
    return (SpeakerSpotlightProperties) super.set(fieldName, value);
  }

  @Override
  public SpeakerSpotlightProperties clone() {
    return (SpeakerSpotlightProperties) super.clone();
  }

}
