/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The border styling properties of the TableBorderCell.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableBorderProperties extends com.google.api.client.json.GenericJson {

  /**
   * The dash style of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dashStyle;

  /**
   * The fill of the table border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableBorderFill tableBorderFill;

  /**
   * The thickness of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension weight;

  /**
   * The dash style of the border.
   * @return value or {@code null} for none
   */
  public java.lang.String getDashStyle() {
    return dashStyle;
  }

  /**
   * The dash style of the border.
   * @param dashStyle dashStyle or {@code null} for none
   */
  public TableBorderProperties setDashStyle(java.lang.String dashStyle) {
    this.dashStyle = dashStyle;
    return this;
  }

  /**
   * The fill of the table border.
   * @return value or {@code null} for none
   */
  public TableBorderFill getTableBorderFill() {
    return tableBorderFill;
  }

  /**
   * The fill of the table border.
   * @param tableBorderFill tableBorderFill or {@code null} for none
   */
  public TableBorderProperties setTableBorderFill(TableBorderFill tableBorderFill) {
    this.tableBorderFill = tableBorderFill;
    return this;
  }

  /**
   * The thickness of the border.
   * @return value or {@code null} for none
   */
  public Dimension getWeight() {
    return weight;
  }

  /**
   * The thickness of the border.
   * @param weight weight or {@code null} for none
   */
  public TableBorderProperties setWeight(Dimension weight) {
    this.weight = weight;
    return this;
  }

  @Override
  public TableBorderProperties set(String fieldName, Object value) {
    return (TableBorderProperties) super.set(fieldName, value);
  }

  @Override
  public TableBorderProperties clone() {
    return (TableBorderProperties) super.clone();
  }

}
