/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Contents of each border row in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableBorderRow extends com.google.api.client.json.GenericJson {

  /**
   * Properties of each border cell. When a border's adjacent table cells are merged, it is not
   * included in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableBorderCell> tableBorderCells;

  static {
    // hack to force ProGuard to consider TableBorderCell used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TableBorderCell.class);
  }

  /**
   * Properties of each border cell. When a border's adjacent table cells are merged, it is not
   * included in the response.
   * @return value or {@code null} for none
   */
  public java.util.List<TableBorderCell> getTableBorderCells() {
    return tableBorderCells;
  }

  /**
   * Properties of each border cell. When a border's adjacent table cells are merged, it is not
   * included in the response.
   * @param tableBorderCells tableBorderCells or {@code null} for none
   */
  public TableBorderRow setTableBorderCells(java.util.List<TableBorderCell> tableBorderCells) {
    this.tableBorderCells = tableBorderCells;
    return this;
  }

  @Override
  public TableBorderRow set(String fieldName, Object value) {
    return (TableBorderRow) super.set(fieldName, value);
  }

  @Override
  public TableBorderRow clone() {
    return (TableBorderRow) super.clone();
  }

}
