/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Properties and contents of each table cell.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableCell extends com.google.api.client.json.GenericJson {

  /**
   * Column span of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer columnSpan;

  /**
   * The location of the cell within the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation location;

  /**
   * Row span of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rowSpan;

  /**
   * The properties of the table cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellProperties tableCellProperties;

  /**
   * The text content of the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextContent text;

  /**
   * Column span of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getColumnSpan() {
    return columnSpan;
  }

  /**
   * Column span of the cell.
   * @param columnSpan columnSpan or {@code null} for none
   */
  public TableCell setColumnSpan(java.lang.Integer columnSpan) {
    this.columnSpan = columnSpan;
    return this;
  }

  /**
   * The location of the cell within the table.
   * @return value or {@code null} for none
   */
  public TableCellLocation getLocation() {
    return location;
  }

  /**
   * The location of the cell within the table.
   * @param location location or {@code null} for none
   */
  public TableCell setLocation(TableCellLocation location) {
    this.location = location;
    return this;
  }

  /**
   * Row span of the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRowSpan() {
    return rowSpan;
  }

  /**
   * Row span of the cell.
   * @param rowSpan rowSpan or {@code null} for none
   */
  public TableCell setRowSpan(java.lang.Integer rowSpan) {
    this.rowSpan = rowSpan;
    return this;
  }

  /**
   * The properties of the table cell.
   * @return value or {@code null} for none
   */
  public TableCellProperties getTableCellProperties() {
    return tableCellProperties;
  }

  /**
   * The properties of the table cell.
   * @param tableCellProperties tableCellProperties or {@code null} for none
   */
  public TableCell setTableCellProperties(TableCellProperties tableCellProperties) {
    this.tableCellProperties = tableCellProperties;
    return this;
  }

  /**
   * The text content of the cell.
   * @return value or {@code null} for none
   */
  public TextContent getText() {
    return text;
  }

  /**
   * The text content of the cell.
   * @param text text or {@code null} for none
   */
  public TableCell setText(TextContent text) {
    this.text = text;
    return this;
  }

  @Override
  public TableCell set(String fieldName, Object value) {
    return (TableCell) super.set(fieldName, value);
  }

  @Override
  public TableCell clone() {
    return (TableCell) super.clone();
  }

}
