/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Properties and contents of each row in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableRow extends com.google.api.client.json.GenericJson {

  /**
   * Height of a row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension rowHeight;

  /**
   * Properties and contents of each cell. Cells that span multiple columns are represented only
   * once with a column_span greater than 1. As a result, the length of this collection does not
   * always match the number of columns of the entire table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableCell> tableCells;

  static {
    // hack to force ProGuard to consider TableCell used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TableCell.class);
  }

  /**
   * Properties of the row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRowProperties tableRowProperties;

  /**
   * Height of a row.
   * @return value or {@code null} for none
   */
  public Dimension getRowHeight() {
    return rowHeight;
  }

  /**
   * Height of a row.
   * @param rowHeight rowHeight or {@code null} for none
   */
  public TableRow setRowHeight(Dimension rowHeight) {
    this.rowHeight = rowHeight;
    return this;
  }

  /**
   * Properties and contents of each cell. Cells that span multiple columns are represented only
   * once with a column_span greater than 1. As a result, the length of this collection does not
   * always match the number of columns of the entire table.
   * @return value or {@code null} for none
   */
  public java.util.List<TableCell> getTableCells() {
    return tableCells;
  }

  /**
   * Properties and contents of each cell. Cells that span multiple columns are represented only
   * once with a column_span greater than 1. As a result, the length of this collection does not
   * always match the number of columns of the entire table.
   * @param tableCells tableCells or {@code null} for none
   */
  public TableRow setTableCells(java.util.List<TableCell> tableCells) {
    this.tableCells = tableCells;
    return this;
  }

  /**
   * Properties of the row.
   * @return value or {@code null} for none
   */
  public TableRowProperties getTableRowProperties() {
    return tableRowProperties;
  }

  /**
   * Properties of the row.
   * @param tableRowProperties tableRowProperties or {@code null} for none
   */
  public TableRow setTableRowProperties(TableRowProperties tableRowProperties) {
    this.tableRowProperties = tableRowProperties;
    return this;
  }

  @Override
  public TableRow set(String fieldName, Object value) {
    return (TableRow) super.set(fieldName, value);
  }

  @Override
  public TableRow clone() {
    return (TableRow) super.clone();
  }

}
