/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The general text content. The text must reside in a compatible shape (e.g. text box or rectangle)
 * or a table cell in a page.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextContent extends com.google.api.client.json.GenericJson {

  /**
   * The bulleted lists contained in this text, keyed by list ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, List> lists;

  static {
    // hack to force ProGuard to consider List used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(List.class);
  }

  /**
   * The text contents broken down into its component parts, including styling information. This
   * property is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextElement> textElements;

  /**
   * The bulleted lists contained in this text, keyed by list ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, List> getLists() {
    return lists;
  }

  /**
   * The bulleted lists contained in this text, keyed by list ID.
   * @param lists lists or {@code null} for none
   */
  public TextContent setLists(java.util.Map<String, List> lists) {
    this.lists = lists;
    return this;
  }

  /**
   * The text contents broken down into its component parts, including styling information. This
   * property is read-only.
   * @return value or {@code null} for none
   */
  public java.util.List<TextElement> getTextElements() {
    return textElements;
  }

  /**
   * The text contents broken down into its component parts, including styling information. This
   * property is read-only.
   * @param textElements textElements or {@code null} for none
   */
  public TextContent setTextElements(java.util.List<TextElement> textElements) {
    this.textElements = textElements;
    return this;
  }

  @Override
  public TextContent set(String fieldName, Object value) {
    return (TextContent) super.set(fieldName, value);
  }

  @Override
  public TextContent clone() {
    return (TextContent) super.clone();
  }

}
