/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Represents the styling that can be applied to a TextRun. If this text is contained in a shape
 * with a parent placeholder, then these text styles may be inherited from the parent. Which text
 * styles are inherited depend on the nesting level of lists: * A text run in a paragraph that is
 * not in a list will inherit its text style from the the newline character in the paragraph at the
 * 0 nesting level of the list inside the parent placeholder. * A text run in a paragraph that is in
 * a list will inherit its text style from the newline character in the paragraph at its
 * corresponding nesting level of the list inside the parent placeholder. Inherited text styles are
 * represented as unset fields in this message. If text is contained in a shape without a parent
 * placeholder, unsetting these fields will revert the style to a value matching the defaults in the
 * Slides editor.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextStyle extends com.google.api.client.json.GenericJson {

  /**
   * The background color of the text. If set, the color is either opaque or transparent, depending
   * on if the `opaque_color` field in it is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OptionalColor backgroundColor;

  /**
   * The text's vertical offset from its normal position. Text with `SUPERSCRIPT` or `SUBSCRIPT`
   * baseline offsets is automatically rendered in a smaller font size, computed based on the
   * `font_size` field. The `font_size` itself is not affected by changes in this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String baselineOffset;

  /**
   * Whether or not the text is rendered as bold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean bold;

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`. Some fonts can affect the weight of the text. If an update request
   * specifies values for both `font_family` and `bold`, the explicitly-set `bold` value is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fontFamily;

  /**
   * The size of the text's font. When read, the `font_size` will specified in points.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension fontSize;

  /**
   * The color of the text itself. If set, the color is either opaque or transparent, depending on
   * if the `opaque_color` field in it is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OptionalColor foregroundColor;

  /**
   * Whether or not the text is italicized.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean italic;

  /**
   * The hyperlink destination of the text. If unset, there is no link. Links are not inherited from
   * parent text. Changing the link in an update request causes some other changes to the text style
   * of the range: * When setting a link, the text foreground color will be set to
   * ThemeColorType.HYPERLINK and the text will be underlined. If these fields are modified in the
   * same request, those values will be used instead of the link defaults. * Setting a link on a
   * text range that overlaps with an existing link will also update the existing link to point to
   * the new URL. * Links are not settable on newline characters. As a result, setting a link on a
   * text range that crosses a paragraph boundary, such as `"ABC\n123"`, will separate the newline
   * character(s) into their own text runs. The link will be applied separately to the runs before
   * and after the newline. * Removing a link will update the text style of the range to match the
   * style of the preceding text (or the default text styles if the preceding text is another link)
   * unless different styles are being set in the same request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Link link;

  /**
   * Whether or not the text is in small capital letters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean smallCaps;

  /**
   * Whether or not the text is struck through.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean strikethrough;

  /**
   * Whether or not the text is underlined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean underline;

  /**
   * The font family and rendered weight of the text. This field is an extension of `font_family`
   * meant to support explicit font weights without breaking backwards compatibility. As such, when
   * reading the style of a range of text, the value of `weighted_font_family#font_family` will
   * always be equal to that of `font_family`. However, when writing, if both fields are included in
   * the field mask (either explicitly or through the wildcard `"*"`), their values are reconciled
   * as follows: * If `font_family` is set and `weighted_font_family` is not, the value of
   * `font_family` is applied with weight `400` ("normal"). * If both fields are set, the value of
   * `font_family` must match that of `weighted_font_family#font_family`. If so, the font family and
   * weight of `weighted_font_family` is applied. Otherwise, a 400 bad request error is returned. *
   * If `weighted_font_family` is set and `font_family` is not, the font family and weight of
   * `weighted_font_family` is applied. * If neither field is set, the font family and weight of the
   * text inherit from the parent. Note that these properties cannot inherit separately from each
   * other. If an update request specifies values for both `weighted_font_family` and `bold`, the
   * `weighted_font_family` is applied first, then `bold`. If `weighted_font_family#weight` is not
   * set, it defaults to `400`. If `weighted_font_family` is set, then
   * `weighted_font_family#font_family` must also be set with a non-empty value. Otherwise, a 400
   * bad request error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WeightedFontFamily weightedFontFamily;

  /**
   * The background color of the text. If set, the color is either opaque or transparent, depending
   * on if the `opaque_color` field in it is set.
   * @return value or {@code null} for none
   */
  public OptionalColor getBackgroundColor() {
    return backgroundColor;
  }

  /**
   * The background color of the text. If set, the color is either opaque or transparent, depending
   * on if the `opaque_color` field in it is set.
   * @param backgroundColor backgroundColor or {@code null} for none
   */
  public TextStyle setBackgroundColor(OptionalColor backgroundColor) {
    this.backgroundColor = backgroundColor;
    return this;
  }

  /**
   * The text's vertical offset from its normal position. Text with `SUPERSCRIPT` or `SUBSCRIPT`
   * baseline offsets is automatically rendered in a smaller font size, computed based on the
   * `font_size` field. The `font_size` itself is not affected by changes in this field.
   * @return value or {@code null} for none
   */
  public java.lang.String getBaselineOffset() {
    return baselineOffset;
  }

  /**
   * The text's vertical offset from its normal position. Text with `SUPERSCRIPT` or `SUBSCRIPT`
   * baseline offsets is automatically rendered in a smaller font size, computed based on the
   * `font_size` field. The `font_size` itself is not affected by changes in this field.
   * @param baselineOffset baselineOffset or {@code null} for none
   */
  public TextStyle setBaselineOffset(java.lang.String baselineOffset) {
    this.baselineOffset = baselineOffset;
    return this;
  }

  /**
   * Whether or not the text is rendered as bold.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBold() {
    return bold;
  }

  /**
   * Whether or not the text is rendered as bold.
   * @param bold bold or {@code null} for none
   */
  public TextStyle setBold(java.lang.Boolean bold) {
    this.bold = bold;
    return this;
  }

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`. Some fonts can affect the weight of the text. If an update request
   * specifies values for both `font_family` and `bold`, the explicitly-set `bold` value is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getFontFamily() {
    return fontFamily;
  }

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`. Some fonts can affect the weight of the text. If an update request
   * specifies values for both `font_family` and `bold`, the explicitly-set `bold` value is used.
   * @param fontFamily fontFamily or {@code null} for none
   */
  public TextStyle setFontFamily(java.lang.String fontFamily) {
    this.fontFamily = fontFamily;
    return this;
  }

  /**
   * The size of the text's font. When read, the `font_size` will specified in points.
   * @return value or {@code null} for none
   */
  public Dimension getFontSize() {
    return fontSize;
  }

  /**
   * The size of the text's font. When read, the `font_size` will specified in points.
   * @param fontSize fontSize or {@code null} for none
   */
  public TextStyle setFontSize(Dimension fontSize) {
    this.fontSize = fontSize;
    return this;
  }

  /**
   * The color of the text itself. If set, the color is either opaque or transparent, depending on
   * if the `opaque_color` field in it is set.
   * @return value or {@code null} for none
   */
  public OptionalColor getForegroundColor() {
    return foregroundColor;
  }

  /**
   * The color of the text itself. If set, the color is either opaque or transparent, depending on
   * if the `opaque_color` field in it is set.
   * @param foregroundColor foregroundColor or {@code null} for none
   */
  public TextStyle setForegroundColor(OptionalColor foregroundColor) {
    this.foregroundColor = foregroundColor;
    return this;
  }

  /**
   * Whether or not the text is italicized.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getItalic() {
    return italic;
  }

  /**
   * Whether or not the text is italicized.
   * @param italic italic or {@code null} for none
   */
  public TextStyle setItalic(java.lang.Boolean italic) {
    this.italic = italic;
    return this;
  }

  /**
   * The hyperlink destination of the text. If unset, there is no link. Links are not inherited from
   * parent text. Changing the link in an update request causes some other changes to the text style
   * of the range: * When setting a link, the text foreground color will be set to
   * ThemeColorType.HYPERLINK and the text will be underlined. If these fields are modified in the
   * same request, those values will be used instead of the link defaults. * Setting a link on a
   * text range that overlaps with an existing link will also update the existing link to point to
   * the new URL. * Links are not settable on newline characters. As a result, setting a link on a
   * text range that crosses a paragraph boundary, such as `"ABC\n123"`, will separate the newline
   * character(s) into their own text runs. The link will be applied separately to the runs before
   * and after the newline. * Removing a link will update the text style of the range to match the
   * style of the preceding text (or the default text styles if the preceding text is another link)
   * unless different styles are being set in the same request.
   * @return value or {@code null} for none
   */
  public Link getLink() {
    return link;
  }

  /**
   * The hyperlink destination of the text. If unset, there is no link. Links are not inherited from
   * parent text. Changing the link in an update request causes some other changes to the text style
   * of the range: * When setting a link, the text foreground color will be set to
   * ThemeColorType.HYPERLINK and the text will be underlined. If these fields are modified in the
   * same request, those values will be used instead of the link defaults. * Setting a link on a
   * text range that overlaps with an existing link will also update the existing link to point to
   * the new URL. * Links are not settable on newline characters. As a result, setting a link on a
   * text range that crosses a paragraph boundary, such as `"ABC\n123"`, will separate the newline
   * character(s) into their own text runs. The link will be applied separately to the runs before
   * and after the newline. * Removing a link will update the text style of the range to match the
   * style of the preceding text (or the default text styles if the preceding text is another link)
   * unless different styles are being set in the same request.
   * @param link link or {@code null} for none
   */
  public TextStyle setLink(Link link) {
    this.link = link;
    return this;
  }

  /**
   * Whether or not the text is in small capital letters.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSmallCaps() {
    return smallCaps;
  }

  /**
   * Whether or not the text is in small capital letters.
   * @param smallCaps smallCaps or {@code null} for none
   */
  public TextStyle setSmallCaps(java.lang.Boolean smallCaps) {
    this.smallCaps = smallCaps;
    return this;
  }

  /**
   * Whether or not the text is struck through.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getStrikethrough() {
    return strikethrough;
  }

  /**
   * Whether or not the text is struck through.
   * @param strikethrough strikethrough or {@code null} for none
   */
  public TextStyle setStrikethrough(java.lang.Boolean strikethrough) {
    this.strikethrough = strikethrough;
    return this;
  }

  /**
   * Whether or not the text is underlined.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUnderline() {
    return underline;
  }

  /**
   * Whether or not the text is underlined.
   * @param underline underline or {@code null} for none
   */
  public TextStyle setUnderline(java.lang.Boolean underline) {
    this.underline = underline;
    return this;
  }

  /**
   * The font family and rendered weight of the text. This field is an extension of `font_family`
   * meant to support explicit font weights without breaking backwards compatibility. As such, when
   * reading the style of a range of text, the value of `weighted_font_family#font_family` will
   * always be equal to that of `font_family`. However, when writing, if both fields are included in
   * the field mask (either explicitly or through the wildcard `"*"`), their values are reconciled
   * as follows: * If `font_family` is set and `weighted_font_family` is not, the value of
   * `font_family` is applied with weight `400` ("normal"). * If both fields are set, the value of
   * `font_family` must match that of `weighted_font_family#font_family`. If so, the font family and
   * weight of `weighted_font_family` is applied. Otherwise, a 400 bad request error is returned. *
   * If `weighted_font_family` is set and `font_family` is not, the font family and weight of
   * `weighted_font_family` is applied. * If neither field is set, the font family and weight of the
   * text inherit from the parent. Note that these properties cannot inherit separately from each
   * other. If an update request specifies values for both `weighted_font_family` and `bold`, the
   * `weighted_font_family` is applied first, then `bold`. If `weighted_font_family#weight` is not
   * set, it defaults to `400`. If `weighted_font_family` is set, then
   * `weighted_font_family#font_family` must also be set with a non-empty value. Otherwise, a 400
   * bad request error is returned.
   * @return value or {@code null} for none
   */
  public WeightedFontFamily getWeightedFontFamily() {
    return weightedFontFamily;
  }

  /**
   * The font family and rendered weight of the text. This field is an extension of `font_family`
   * meant to support explicit font weights without breaking backwards compatibility. As such, when
   * reading the style of a range of text, the value of `weighted_font_family#font_family` will
   * always be equal to that of `font_family`. However, when writing, if both fields are included in
   * the field mask (either explicitly or through the wildcard `"*"`), their values are reconciled
   * as follows: * If `font_family` is set and `weighted_font_family` is not, the value of
   * `font_family` is applied with weight `400` ("normal"). * If both fields are set, the value of
   * `font_family` must match that of `weighted_font_family#font_family`. If so, the font family and
   * weight of `weighted_font_family` is applied. Otherwise, a 400 bad request error is returned. *
   * If `weighted_font_family` is set and `font_family` is not, the font family and weight of
   * `weighted_font_family` is applied. * If neither field is set, the font family and weight of the
   * text inherit from the parent. Note that these properties cannot inherit separately from each
   * other. If an update request specifies values for both `weighted_font_family` and `bold`, the
   * `weighted_font_family` is applied first, then `bold`. If `weighted_font_family#weight` is not
   * set, it defaults to `400`. If `weighted_font_family` is set, then
   * `weighted_font_family#font_family` must also be set with a non-empty value. Otherwise, a 400
   * bad request error is returned.
   * @param weightedFontFamily weightedFontFamily or {@code null} for none
   */
  public TextStyle setWeightedFontFamily(WeightedFontFamily weightedFontFamily) {
    this.weightedFontFamily = weightedFontFamily;
    return this;
  }

  @Override
  public TextStyle set(String fieldName, Object value) {
    return (TextStyle) super.set(fieldName, value);
  }

  @Override
  public TextStyle clone() {
    return (TextStyle) super.clone();
  }

}
