/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * The thumbnail of a page.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Thumbnail extends com.google.api.client.json.GenericJson {

  /**
   * The content URL of the thumbnail image. The URL to the image has a default lifetime of 30
   * minutes. This URL is tagged with the account of the requester. Anyone with the URL effectively
   * accesses the image as the original requester. Access to the image may be lost if the
   * presentation's sharing settings change. The mime type of the thumbnail image is the same as
   * specified in the `GetPageThumbnailRequest`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentUrl;

  /**
   * The positive height in pixels of the thumbnail image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer height;

  /**
   * The positive width in pixels of the thumbnail image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer width;

  /**
   * The content URL of the thumbnail image. The URL to the image has a default lifetime of 30
   * minutes. This URL is tagged with the account of the requester. Anyone with the URL effectively
   * accesses the image as the original requester. Access to the image may be lost if the
   * presentation's sharing settings change. The mime type of the thumbnail image is the same as
   * specified in the `GetPageThumbnailRequest`.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentUrl() {
    return contentUrl;
  }

  /**
   * The content URL of the thumbnail image. The URL to the image has a default lifetime of 30
   * minutes. This URL is tagged with the account of the requester. Anyone with the URL effectively
   * accesses the image as the original requester. Access to the image may be lost if the
   * presentation's sharing settings change. The mime type of the thumbnail image is the same as
   * specified in the `GetPageThumbnailRequest`.
   * @param contentUrl contentUrl or {@code null} for none
   */
  public Thumbnail setContentUrl(java.lang.String contentUrl) {
    this.contentUrl = contentUrl;
    return this;
  }

  /**
   * The positive height in pixels of the thumbnail image.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHeight() {
    return height;
  }

  /**
   * The positive height in pixels of the thumbnail image.
   * @param height height or {@code null} for none
   */
  public Thumbnail setHeight(java.lang.Integer height) {
    this.height = height;
    return this;
  }

  /**
   * The positive width in pixels of the thumbnail image.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWidth() {
    return width;
  }

  /**
   * The positive width in pixels of the thumbnail image.
   * @param width width or {@code null} for none
   */
  public Thumbnail setWidth(java.lang.Integer width) {
    this.width = width;
    return this;
  }

  @Override
  public Thumbnail set(String fieldName, Object value) {
    return (Thumbnail) super.set(fieldName, value);
  }

  @Override
  public Thumbnail clone() {
    return (Thumbnail) super.clone();
  }

}
