/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Ungroups objects, such as groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UngroupObjectsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The object IDs of the objects to ungroup. Only groups that are not inside other groups can be
   * ungrouped. All the groups should be on the same page. The group itself is deleted. The visual
   * sizes and positions of all the children are preserved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> objectIds;

  /**
   * The object IDs of the objects to ungroup. Only groups that are not inside other groups can be
   * ungrouped. All the groups should be on the same page. The group itself is deleted. The visual
   * sizes and positions of all the children are preserved.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getObjectIds() {
    return objectIds;
  }

  /**
   * The object IDs of the objects to ungroup. Only groups that are not inside other groups can be
   * ungrouped. All the groups should be on the same page. The group itself is deleted. The visual
   * sizes and positions of all the children are preserved.
   * @param objectIds objectIds or {@code null} for none
   */
  public UngroupObjectsRequest setObjectIds(java.util.List<java.lang.String> objectIds) {
    this.objectIds = objectIds;
    return this;
  }

  @Override
  public UngroupObjectsRequest set(String fieldName, Object value) {
    return (UngroupObjectsRequest) super.set(fieldName, value);
  }

  @Override
  public UngroupObjectsRequest clone() {
    return (UngroupObjectsRequest) super.clone();
  }

}
