/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the alt text title and/or description of a page element.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdatePageElementAltTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * The updated alt text description of the page element. If unset the existing value will be
   * maintained. The description is exposed to screen readers and other accessibility interfaces.
   * Only use human readable values related to the content of the page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The object ID of the page element the updates are applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The updated alt text title of the page element. If unset the existing value will be maintained.
   * The title is exposed to screen readers and other accessibility interfaces. Only use human
   * readable values related to the content of the page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The updated alt text description of the page element. If unset the existing value will be
   * maintained. The description is exposed to screen readers and other accessibility interfaces.
   * Only use human readable values related to the content of the page element.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The updated alt text description of the page element. If unset the existing value will be
   * maintained. The description is exposed to screen readers and other accessibility interfaces.
   * Only use human readable values related to the content of the page element.
   * @param description description or {@code null} for none
   */
  public UpdatePageElementAltTextRequest setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The object ID of the page element the updates are applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the page element the updates are applied to.
   * @param objectId objectId or {@code null} for none
   */
  public UpdatePageElementAltTextRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The updated alt text title of the page element. If unset the existing value will be maintained.
   * The title is exposed to screen readers and other accessibility interfaces. Only use human
   * readable values related to the content of the page element.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The updated alt text title of the page element. If unset the existing value will be maintained.
   * The title is exposed to screen readers and other accessibility interfaces. Only use human
   * readable values related to the content of the page element.
   * @param title title or {@code null} for none
   */
  public UpdatePageElementAltTextRequest setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public UpdatePageElementAltTextRequest set(String fieldName, Object value) {
    return (UpdatePageElementAltTextRequest) super.set(fieldName, value);
  }

  @Override
  public UpdatePageElementAltTextRequest clone() {
    return (UpdatePageElementAltTextRequest) super.clone();
  }

}
