/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the transform of a page element. Updating the transform of a group will change the
 * absolute transform of the page elements in that group, which can change their visual appearance.
 * See the documentation for PageElement.transform for more details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdatePageElementTransformRequest extends com.google.api.client.json.GenericJson {

  /**
   * The apply mode of the transform update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String applyMode;

  /**
   * The object ID of the page element to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The input transform matrix used to update the page element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AffineTransform transform;

  /**
   * The apply mode of the transform update.
   * @return value or {@code null} for none
   */
  public java.lang.String getApplyMode() {
    return applyMode;
  }

  /**
   * The apply mode of the transform update.
   * @param applyMode applyMode or {@code null} for none
   */
  public UpdatePageElementTransformRequest setApplyMode(java.lang.String applyMode) {
    this.applyMode = applyMode;
    return this;
  }

  /**
   * The object ID of the page element to update.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the page element to update.
   * @param objectId objectId or {@code null} for none
   */
  public UpdatePageElementTransformRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The input transform matrix used to update the page element.
   * @return value or {@code null} for none
   */
  public AffineTransform getTransform() {
    return transform;
  }

  /**
   * The input transform matrix used to update the page element.
   * @param transform transform or {@code null} for none
   */
  public UpdatePageElementTransformRequest setTransform(AffineTransform transform) {
    this.transform = transform;
    return this;
  }

  @Override
  public UpdatePageElementTransformRequest set(String fieldName, Object value) {
    return (UpdatePageElementTransformRequest) super.set(fieldName, value);
  }

  @Override
  public UpdatePageElementTransformRequest clone() {
    return (UpdatePageElementTransformRequest) super.clone();
  }

}
