/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the properties of a Slide.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSlidePropertiesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * 'slideProperties' is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update whether a slide is skipped, set `fields` to
   * `"isSkipped"`. To reset a property to its default value, include its field name in the field
   * mask but leave the field itself unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The object ID of the slide the update is applied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The slide properties to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SlideProperties slideProperties;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * 'slideProperties' is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update whether a slide is skipped, set `fields` to
   * `"isSkipped"`. To reset a property to its default value, include its field name in the field
   * mask but leave the field itself unset.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * 'slideProperties' is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update whether a slide is skipped, set `fields` to
   * `"isSkipped"`. To reset a property to its default value, include its field name in the field
   * mask but leave the field itself unset.
   * @param fields fields or {@code null} for none
   */
  public UpdateSlidePropertiesRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The object ID of the slide the update is applied to.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The object ID of the slide the update is applied to.
   * @param objectId objectId or {@code null} for none
   */
  public UpdateSlidePropertiesRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The slide properties to update.
   * @return value or {@code null} for none
   */
  public SlideProperties getSlideProperties() {
    return slideProperties;
  }

  /**
   * The slide properties to update.
   * @param slideProperties slideProperties or {@code null} for none
   */
  public UpdateSlidePropertiesRequest setSlideProperties(SlideProperties slideProperties) {
    this.slideProperties = slideProperties;
    return this;
  }

  @Override
  public UpdateSlidePropertiesRequest set(String fieldName, Object value) {
    return (UpdateSlidePropertiesRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSlidePropertiesRequest clone() {
    return (UpdateSlidePropertiesRequest) super.clone();
  }

}
