/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Updates the position of slides in the presentation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSlidesPositionRequest extends com.google.api.client.json.GenericJson {

  /**
   * The index where the slides should be inserted, based on the slide arrangement before the move
   * takes place. Must be between zero and the number of slides in the presentation, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer insertionIndex;

  /**
   * The IDs of the slides in the presentation that should be moved. The slides in this list must be
   * in existing presentation order, without duplicates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> slideObjectIds;

  /**
   * The index where the slides should be inserted, based on the slide arrangement before the move
   * takes place. Must be between zero and the number of slides in the presentation, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInsertionIndex() {
    return insertionIndex;
  }

  /**
   * The index where the slides should be inserted, based on the slide arrangement before the move
   * takes place. Must be between zero and the number of slides in the presentation, inclusive.
   * @param insertionIndex insertionIndex or {@code null} for none
   */
  public UpdateSlidesPositionRequest setInsertionIndex(java.lang.Integer insertionIndex) {
    this.insertionIndex = insertionIndex;
    return this;
  }

  /**
   * The IDs of the slides in the presentation that should be moved. The slides in this list must be
   * in existing presentation order, without duplicates.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSlideObjectIds() {
    return slideObjectIds;
  }

  /**
   * The IDs of the slides in the presentation that should be moved. The slides in this list must be
   * in existing presentation order, without duplicates.
   * @param slideObjectIds slideObjectIds or {@code null} for none
   */
  public UpdateSlidesPositionRequest setSlideObjectIds(java.util.List<java.lang.String> slideObjectIds) {
    this.slideObjectIds = slideObjectIds;
    return this;
  }

  @Override
  public UpdateSlidesPositionRequest set(String fieldName, Object value) {
    return (UpdateSlidesPositionRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSlidesPositionRequest clone() {
    return (UpdateSlidesPositionRequest) super.clone();
  }

}
