/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Represents a font family and weight used to style a TextRun.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WeightedFontFamily extends com.google.api.client.json.GenericJson {

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fontFamily;

  /**
   * The rendered weight of the text. This field can have any value that is a multiple of `100`
   * between `100` and `900`, inclusive. This range corresponds to the numerical values described in
   * the CSS 2.1 Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-
   * boldness), with non-numerical values disallowed. Weights greater than or equal to `700` are
   * considered bold, and weights less than `700`are not bold. The default value is `400`
   * ("normal").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer weight;

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * @return value or {@code null} for none
   */
  public java.lang.String getFontFamily() {
    return fontFamily;
  }

  /**
   * The font family of the text. The font family can be any font from the Font menu in Slides or
   * from [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * @param fontFamily fontFamily or {@code null} for none
   */
  public WeightedFontFamily setFontFamily(java.lang.String fontFamily) {
    this.fontFamily = fontFamily;
    return this;
  }

  /**
   * The rendered weight of the text. This field can have any value that is a multiple of `100`
   * between `100` and `900`, inclusive. This range corresponds to the numerical values described in
   * the CSS 2.1 Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-
   * boldness), with non-numerical values disallowed. Weights greater than or equal to `700` are
   * considered bold, and weights less than `700`are not bold. The default value is `400`
   * ("normal").
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWeight() {
    return weight;
  }

  /**
   * The rendered weight of the text. This field can have any value that is a multiple of `100`
   * between `100` and `900`, inclusive. This range corresponds to the numerical values described in
   * the CSS 2.1 Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-
   * boldness), with non-numerical values disallowed. Weights greater than or equal to `700` are
   * considered bold, and weights less than `700`are not bold. The default value is `400`
   * ("normal").
   * @param weight weight or {@code null} for none
   */
  public WeightedFontFamily setWeight(java.lang.Integer weight) {
    this.weight = weight;
    return this;
  }

  @Override
  public WeightedFontFamily set(String fieldName, Object value) {
    return (WeightedFontFamily) super.set(fieldName, value);
  }

  @Override
  public WeightedFontFamily clone() {
    return (WeightedFontFamily) super.clone();
  }

}
