/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.slides.v1.model;

/**
 * Provides control over how write requests are executed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Slides API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WriteControl extends com.google.api.client.json.GenericJson {

  /**
   * The revision ID of the presentation required for the write request. If specified and the
   * required revision ID doesn't match the presentation's current revision ID, the request is not
   * processed and returns a 400 bad request error. When a required revision ID is returned in a
   * response, it indicates the revision ID of the document after the request was applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requiredRevisionId;

  /**
   * The revision ID of the presentation required for the write request. If specified and the
   * required revision ID doesn't match the presentation's current revision ID, the request is not
   * processed and returns a 400 bad request error. When a required revision ID is returned in a
   * response, it indicates the revision ID of the document after the request was applied.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequiredRevisionId() {
    return requiredRevisionId;
  }

  /**
   * The revision ID of the presentation required for the write request. If specified and the
   * required revision ID doesn't match the presentation's current revision ID, the request is not
   * processed and returns a 400 bad request error. When a required revision ID is returned in a
   * response, it indicates the revision ID of the document after the request was applied.
   * @param requiredRevisionId requiredRevisionId or {@code null} for none
   */
  public WriteControl setRequiredRevisionId(java.lang.String requiredRevisionId) {
    this.requiredRevisionId = requiredRevisionId;
    return this;
  }

  @Override
  public WriteControl set(String fieldName, Object value) {
    return (WriteControl) super.set(fieldName, value);
  }

  @Override
  public WriteControl clone() {
    return (WriteControl) super.clone();
  }

}
