/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.slides.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.slides.v1.SlidesRequest;
import com.google.api.services.slides.v1.SlidesRequestInitializer;
import com.google.api.services.slides.v1.model.BatchUpdatePresentationRequest;
import com.google.api.services.slides.v1.model.BatchUpdatePresentationResponse;
import com.google.api.services.slides.v1.model.Page;
import com.google.api.services.slides.v1.model.Presentation;
import com.google.api.services.slides.v1.model.Thumbnail;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slides
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://slides.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://slides.googleapis.com/";

    public Slides(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Slides(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Presentations presentations() {
        return new Presentations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Google Slides API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://slides.googleapis.com/", Slides.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Slides.DEFAULT_BATCH_PATH);
        }

        public Slides build() {
            return new Slides(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setSlidesRequestInitializer(SlidesRequestInitializer slidesRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)slidesRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Presentations {
        public BatchUpdate batchUpdate(String string, BatchUpdatePresentationRequest batchUpdatePresentationRequest) throws IOException {
            BatchUpdate batchUpdate = new BatchUpdate(string, batchUpdatePresentationRequest);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
            return batchUpdate;
        }

        public Create create(Presentation presentation) throws IOException {
            Create create = new Create(presentation);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Slides.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Pages pages() {
            return new Pages();
        }

        public class Pages {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Slides.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetThumbnail getThumbnail(String string, String string2) throws IOException {
                GetThumbnail getThumbnail = new GetThumbnail(string, string2);
                Slides.this.initialize((AbstractGoogleClientRequest<?>)getThumbnail);
                return getThumbnail;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetThumbnail
            extends SlidesRequest<Thumbnail> {
                private static final String REST_PATH = "v1/presentations/{presentationId}/pages/{pageObjectId}/thumbnail";
                @Key
                private String presentationId;
                @Key
                private String pageObjectId;
                @Key(value="thumbnailProperties.mimeType")
                private String thumbnailPropertiesMimeType;
                @Key(value="thumbnailProperties.thumbnailSize")
                private String thumbnailPropertiesThumbnailSize;

                protected GetThumbnail(String string, String string2) {
                    super(Slides.this, "GET", REST_PATH, null, Thumbnail.class);
                    this.presentationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter presentationId must be specified.");
                    this.pageObjectId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter pageObjectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetThumbnail set$Xgafv(String string) {
                    return (GetThumbnail)super.set$Xgafv(string);
                }

                public GetThumbnail setAccessToken(String string) {
                    return (GetThumbnail)super.setAccessToken(string);
                }

                public GetThumbnail setAlt(String string) {
                    return (GetThumbnail)super.setAlt(string);
                }

                public GetThumbnail setCallback(String string) {
                    return (GetThumbnail)super.setCallback(string);
                }

                public GetThumbnail setFields(String string) {
                    return (GetThumbnail)super.setFields(string);
                }

                public GetThumbnail setKey(String string) {
                    return (GetThumbnail)super.setKey(string);
                }

                public GetThumbnail setOauthToken(String string) {
                    return (GetThumbnail)super.setOauthToken(string);
                }

                public GetThumbnail setPrettyPrint(Boolean bl) {
                    return (GetThumbnail)super.setPrettyPrint(bl);
                }

                public GetThumbnail setQuotaUser(String string) {
                    return (GetThumbnail)super.setQuotaUser(string);
                }

                public GetThumbnail setUploadType(String string) {
                    return (GetThumbnail)super.setUploadType(string);
                }

                public GetThumbnail setUploadProtocol(String string) {
                    return (GetThumbnail)super.setUploadProtocol(string);
                }

                public String getPresentationId() {
                    return this.presentationId;
                }

                public GetThumbnail setPresentationId(String string) {
                    this.presentationId = string;
                    return this;
                }

                public String getPageObjectId() {
                    return this.pageObjectId;
                }

                public GetThumbnail setPageObjectId(String string) {
                    this.pageObjectId = string;
                    return this;
                }

                public String getThumbnailPropertiesMimeType() {
                    return this.thumbnailPropertiesMimeType;
                }

                public GetThumbnail setThumbnailPropertiesMimeType(String string) {
                    this.thumbnailPropertiesMimeType = string;
                    return this;
                }

                public String getThumbnailPropertiesThumbnailSize() {
                    return this.thumbnailPropertiesThumbnailSize;
                }

                public GetThumbnail setThumbnailPropertiesThumbnailSize(String string) {
                    this.thumbnailPropertiesThumbnailSize = string;
                    return this;
                }

                @Override
                public GetThumbnail set(String string, Object object) {
                    return (GetThumbnail)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends SlidesRequest<Page> {
                private static final String REST_PATH = "v1/presentations/{presentationId}/pages/{pageObjectId}";
                @Key
                private String presentationId;
                @Key
                private String pageObjectId;

                protected Get(String string, String string2) {
                    super(Slides.this, "GET", REST_PATH, null, Page.class);
                    this.presentationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter presentationId must be specified.");
                    this.pageObjectId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter pageObjectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getPresentationId() {
                    return this.presentationId;
                }

                public Get setPresentationId(String string) {
                    this.presentationId = string;
                    return this;
                }

                public String getPageObjectId() {
                    return this.pageObjectId;
                }

                public Get setPageObjectId(String string) {
                    this.pageObjectId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SlidesRequest<Presentation> {
            private static final String REST_PATH = "v1/presentations/{+presentationId}";
            private final Pattern PRESENTATION_ID_PATTERN;
            @Key
            private String presentationId;

            protected Get(String string) {
                super(Slides.this, "GET", REST_PATH, null, Presentation.class);
                this.PRESENTATION_ID_PATTERN = Pattern.compile("^[^/]+$");
                this.presentationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter presentationId must be specified.");
                if (!Slides.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PRESENTATION_ID_PATTERN.matcher(string).matches(), (Object)"Parameter presentationId must conform to the pattern ^[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getPresentationId() {
                return this.presentationId;
            }

            public Get setPresentationId(String string) {
                if (!Slides.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PRESENTATION_ID_PATTERN.matcher(string).matches(), (Object)"Parameter presentationId must conform to the pattern ^[^/]+$");
                }
                this.presentationId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends SlidesRequest<Presentation> {
            private static final String REST_PATH = "v1/presentations";

            protected Create(Presentation presentation) {
                super(Slides.this, "POST", REST_PATH, (Object)presentation, Presentation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BatchUpdate
        extends SlidesRequest<BatchUpdatePresentationResponse> {
            private static final String REST_PATH = "v1/presentations/{presentationId}:batchUpdate";
            @Key
            private String presentationId;

            protected BatchUpdate(String string, BatchUpdatePresentationRequest batchUpdatePresentationRequest) {
                super(Slides.this, "POST", REST_PATH, (Object)batchUpdatePresentationRequest, BatchUpdatePresentationResponse.class);
                this.presentationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter presentationId must be specified.");
            }

            public BatchUpdate set$Xgafv(String string) {
                return (BatchUpdate)super.set$Xgafv(string);
            }

            public BatchUpdate setAccessToken(String string) {
                return (BatchUpdate)super.setAccessToken(string);
            }

            public BatchUpdate setAlt(String string) {
                return (BatchUpdate)super.setAlt(string);
            }

            public BatchUpdate setCallback(String string) {
                return (BatchUpdate)super.setCallback(string);
            }

            public BatchUpdate setFields(String string) {
                return (BatchUpdate)super.setFields(string);
            }

            public BatchUpdate setKey(String string) {
                return (BatchUpdate)super.setKey(string);
            }

            public BatchUpdate setOauthToken(String string) {
                return (BatchUpdate)super.setOauthToken(string);
            }

            public BatchUpdate setPrettyPrint(Boolean bl) {
                return (BatchUpdate)super.setPrettyPrint(bl);
            }

            public BatchUpdate setQuotaUser(String string) {
                return (BatchUpdate)super.setQuotaUser(string);
            }

            public BatchUpdate setUploadType(String string) {
                return (BatchUpdate)super.setUploadType(string);
            }

            public BatchUpdate setUploadProtocol(String string) {
                return (BatchUpdate)super.setUploadProtocol(string);
            }

            public String getPresentationId() {
                return this.presentationId;
            }

            public BatchUpdate setPresentationId(String string) {
                this.presentationId = string;
                return this;
            }

            @Override
            public BatchUpdate set(String string, Object object) {
                return (BatchUpdate)super.set(string, object);
            }
        }
    }
}

